/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player.tab;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.world.entity.player.ProfilePublicKey;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.common.entity.player.tab.SpongeTabList;

public final class SpongeTabListEntry
implements TabListEntry {
    private final SpongeTabList list;
    private final GameProfile profile;
    private @Nullable Component displayName;
    private int latency;
    private GameMode gameMode;
    private boolean updateWithoutSend;
    private final ProfilePublicKey.Data profilePublicKey;

    public SpongeTabListEntry(TabList list, GameProfile profile, @Nullable Component displayName, int latency, GameMode gameMode, ProfilePublicKey.Data profilePublicKey) {
        Preconditions.checkState((boolean)(list instanceof SpongeTabList), (Object)"list is not a SpongeTabList");
        this.list = (SpongeTabList)list;
        this.profile = (GameProfile)Preconditions.checkNotNull((Object)profile, (Object)"profile");
        this.displayName = displayName;
        this.latency = latency;
        this.gameMode = (GameMode)Preconditions.checkNotNull((Object)gameMode, (Object)"game mode");
        this.profilePublicKey = profilePublicKey;
    }

    @Override
    public TabList list() {
        return this.list;
    }

    @Override
    public GameProfile profile() {
        return this.profile;
    }

    @Override
    public Optional<Component> displayName() {
        return Optional.ofNullable(this.displayName);
    }

    @Override
    public TabListEntry setDisplayName(@Nullable Component displayName) {
        this.displayName = displayName;
        this.sendUpdate(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME);
        return this;
    }

    @Override
    public int latency() {
        return this.latency;
    }

    @Override
    public TabListEntry setLatency(int latency) {
        this.latency = latency;
        this.sendUpdate(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LATENCY);
        return this;
    }

    @Override
    public GameMode gameMode() {
        return this.gameMode;
    }

    @Override
    public TabListEntry setGameMode(GameMode gameMode) {
        this.gameMode = (GameMode)Preconditions.checkNotNull((Object)gameMode, (Object)"game mode");
        this.sendUpdate(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_GAME_MODE);
        return this;
    }

    public ProfilePublicKey.Data profilePublicKey() {
        return this.profilePublicKey;
    }

    private void sendUpdate(ClientboundPlayerInfoUpdatePacket.Action action) {
        if (this.updateWithoutSend) {
            this.updateWithoutSend = false;
            return;
        }
        this.list.sendUpdate(this, EnumSet.of(action));
    }

    public void updateWithoutSend() {
        this.updateWithoutSend = true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TabListEntry that = (TabListEntry)other;
        return Objects.equal((Object)this.profile.uniqueId(), (Object)that.profile().uniqueId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.profile});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("profile", (Object)this.profile).add("latency", this.latency).add("displayName", (Object)this.displayName).add("gameMode", (Object)this.gameMode).toString();
    }
}

