/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapIndex;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.entity.Jukebox;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.InstrumentType;
import org.spongepowered.api.data.type.NotePitch;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.CreateMapEvent;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.CollideBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.RotateEntityEvent;
import org.spongepowered.api.event.entity.ai.SetAITargetEvent;
import org.spongepowered.api.event.entity.explosive.DetonateExplosiveEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.event.sound.PlaySoundEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.map.MapInfo;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.DefaultWorldKeys;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.map.MapIdTrackerBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.storage.MapItemSavedDataBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.entity.projectile.UnknownProjectileSource;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.map.SpongeMapStorage;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.math.vector.Vector3d;

public final class SpongeCommonEventFactory {
    private static final double MOVEMENT_GRID_POINTS_PER_BLOCK = 8.0;
    private static final double ROTATION_GRID_POINTS_PER_UNIT = 20.0;

    public static <T extends net.minecraft.world.entity.Entity> CollideEntityEvent callCollideEntityEvent(@Nullable net.minecraft.world.entity.Entity sourceEntity, List<T> entities) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseContext<@NonNull ?> currentContext = phaseTracker.getPhaseContext();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            if (sourceEntity != null && currentContext.getSource() != sourceEntity) {
                frame.pushCause(sourceEntity);
            }
            currentContext.addCreatorAndNotifierToCauseStack(frame);
            List<Entity> spEntities = entities;
            CollideEntityEvent event = SpongeEventFactory.createCollideEntityEvent(PhaseTracker.getCauseStackManager().currentCause(), spEntities);
            SpongeCommon.post(event);
            CollideEntityEvent collideEntityEvent = event;
            return collideEntityEvent;
        }
    }

    public static boolean handlePistonEvent(TrackedWorldBridge world, BlockPos pos, BlockState blockstate, int eventId) {
        boolean extending = eventId == 0;
        net.minecraft.core.Direction direction = (net.minecraft.core.Direction)blockstate.getValue((Property)DirectionalBlock.FACING);
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((ServerWorld)((Object)world)).state((org.spongepowered.api.block.BlockState)blockstate).position(pos.getX(), pos.getY(), pos.getZ()).build();
        HashSet<ServerLocation> locations = new HashSet<ServerLocation>();
        locations.add(ServerLocation.of((ServerWorld)((Object)world), pos.getX(), pos.getY(), pos.getZ()));
        PistonStructureResolver movedBlocks = new PistonStructureResolver((Level)((ServerLevel)world), pos, direction, extending);
        movedBlocks.resolve();
        Stream.concat(movedBlocks.getToPush().stream(), movedBlocks.getToDestroy().stream()).map(block -> ServerLocation.of((ServerWorld)((Object)world), block.getX(), block.getY(), block.getZ())).collect(Collectors.toCollection(() -> locations));
        if (extending && movedBlocks.getToDestroy().isEmpty()) {
            List movedPositions = movedBlocks.getToPush();
            BlockPos offsetPos = movedPositions.isEmpty() ? pos.relative(direction) : ((BlockPos)movedPositions.get(movedPositions.size() - 1)).relative(direction);
            locations.add(ServerLocation.of((ServerWorld)((Object)world), offsetPos.getX(), offsetPos.getY(), offsetPos.getZ()));
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            if (extending) {
                frame.addContext(EventContextKeys.PISTON_EXTEND, (ServerWorld)((Object)world));
            } else {
                frame.addContext(EventContextKeys.PISTON_RETRACT, (ServerWorld)((Object)world));
            }
            boolean bl = SpongeCommonEventFactory.callChangeBlockEventPre((ServerLevelBridge)((Object)world), (ImmutableList<ServerLocation>)ImmutableList.copyOf(locations), (Object)locatable).isCancelled();
            return bl;
        }
    }

    public static ChangeBlockEvent.Pre callChangeBlockEventPre(ServerLevelBridge worldIn, BlockPos pos) {
        return SpongeCommonEventFactory.callChangeBlockEventPre(worldIn, (ImmutableList<ServerLocation>)ImmutableList.of((Object)ServerLocation.of((ServerWorld)((Object)worldIn), pos.getX(), pos.getY(), pos.getZ())), null);
    }

    public static ChangeBlockEvent.Pre callChangeBlockEventPre(ServerLevelBridge worldIn, BlockPos pos, Object source) {
        return SpongeCommonEventFactory.callChangeBlockEventPre(worldIn, (ImmutableList<ServerLocation>)ImmutableList.of((Object)ServerLocation.of((ServerWorld)((Object)worldIn), pos.getX(), pos.getY(), pos.getZ())), source);
    }

    private static ChangeBlockEvent.Pre callChangeBlockEventPre(ServerLevelBridge worldIn, ImmutableList<ServerLocation> locations, @Nullable Object source) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            PhaseContext<@NonNull ?> phaseContext = PhaseTracker.getInstance().getPhaseContext();
            if (source == null) {
                source = phaseContext.getSource() == null ? worldIn : phaseContext.getSource();
            }
            net.minecraft.world.entity.player.Player player = null;
            frame.pushCause(source);
            if (source instanceof Player && ((PlatformEntityBridge)(player = (net.minecraft.world.entity.player.Player)source)).bridge$isFakePlayer()) {
                frame.addContext(EventContextKeys.FAKE_PLAYER, (Player)player);
            }
            if (phaseContext.getCreator().isPresent()) {
                phaseContext.getCreator().ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
            } else if (player instanceof ServerPlayer) {
                frame.addContext(EventContextKeys.CREATOR, ((ServerPlayer)player).uniqueId());
            }
            phaseContext.applyNotifierIfAvailable(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            ChangeBlockEvent.Pre event = SpongeEventFactory.createChangeBlockEventPre(frame.currentCause(), locations, (ServerWorld)((Object)worldIn));
            SpongeCommon.post(event);
            ChangeBlockEvent.Pre pre = event;
            return pre;
        }
    }

    public static InteractEntityEvent.Primary callInteractEntityEventPrimary(net.minecraft.server.level.ServerPlayer player, ItemStack stack, net.minecraft.world.entity.Entity entity, InteractionHand hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext((net.minecraft.world.entity.player.Player)player, stack, hand, null, entity, frame);
            InteractEntityEvent.Primary event = SpongeEventFactory.createInteractEntityEventPrimary(frame.currentCause(), (Entity)entity);
            if (entity instanceof Player && !((ServerWorld)player.level()).properties().pvp()) {
                event.setCancelled(true);
            }
            SpongeCommon.post(event);
            InteractEntityEvent.Primary primary = event;
            return primary;
        }
    }

    public static InteractEntityEvent.Secondary callInteractEntityEventSecondary(net.minecraft.server.level.ServerPlayer player, ItemStack stack, net.minecraft.world.entity.Entity entity, InteractionHand hand, @Nullable Vector3d hitVec) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext((net.minecraft.world.entity.player.Player)player, stack, hand, null, entity, frame);
            InteractEntityEvent.Secondary event = hitVec == null ? SpongeEventFactory.createInteractEntityEventSecondaryOn(frame.currentCause(), (Entity)entity) : SpongeEventFactory.createInteractEntityEventSecondaryAt(frame.currentCause(), (Entity)entity, hitVec);
            SpongeCommon.post(event);
            InteractEntityEvent.Secondary secondary = event;
            return secondary;
        }
    }

    public static InteractItemEvent.Primary callInteractItemEventPrimary(net.minecraft.world.entity.player.Player player, ItemStack stack, InteractionHand hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext(player, stack, hand, null, null, frame);
            InteractItemEvent.Primary event = SpongeEventFactory.createInteractItemEventPrimary(frame.currentCause(), ItemStackUtil.snapshotOf(stack));
            SpongeCommon.post(event);
            InteractItemEvent.Primary primary = event;
            return primary;
        }
    }

    public static InteractItemEvent.Secondary callInteractItemEventSecondary(net.minecraft.world.entity.player.Player player, ItemStack stack, InteractionHand hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext(player, stack, hand, null, null, frame);
            InteractItemEvent.Secondary event = SpongeEventFactory.createInteractItemEventSecondary(frame.currentCause(), ItemStackUtil.snapshotOf(stack));
            SpongeCommon.post(event);
            InteractItemEvent.Secondary secondary = event;
            return secondary;
        }
    }

    public static InteractBlockEvent.Primary callInteractBlockEventPrimary(ServerboundPlayerActionPacket.Action action, net.minecraft.world.entity.player.Player player, ItemStack heldItem, BlockSnapshot blockSnapshot, InteractionHand hand, @Nullable net.minecraft.core.Direction side) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext(player, heldItem, hand, blockSnapshot, null, frame);
            Direction direction = side != null ? DirectionFacingProvider.INSTANCE.getKey(side).get() : Direction.NONE;
            InteractBlockEvent.Primary event = switch (action) {
                case ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK -> SpongeEventFactory.createInteractBlockEventPrimaryStart(frame.currentCause(), blockSnapshot, direction);
                case ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK -> SpongeEventFactory.createInteractBlockEventPrimaryStop(frame.currentCause(), blockSnapshot, direction);
                case ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK -> SpongeEventFactory.createInteractBlockEventPrimaryFinish(frame.currentCause(), blockSnapshot, direction);
                default -> throw new IllegalStateException("unreachable code");
            };
            SpongeCommon.post(event);
            InteractBlockEvent.Primary primary = event;
            return primary;
        }
    }

    public static InteractBlockEvent.Secondary callInteractBlockEventSecondary(net.minecraft.world.entity.player.Player player, ItemStack heldItem, Vector3d hitVec, BlockSnapshot targetBlock, Direction targetSide, InteractionHand hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext(player, heldItem, hand, targetBlock, null, frame);
            InteractBlockEvent.Secondary event = SpongeEventFactory.createInteractBlockEventSecondary(frame.currentCause(), Tristate.UNDEFINED, Tristate.UNDEFINED, Tristate.UNDEFINED, Tristate.UNDEFINED, targetBlock, hitVec, targetSide);
            SpongeCommon.post(event);
            InteractBlockEvent.Secondary secondary = event;
            return secondary;
        }
    }

    public static void applyCommonInteractContext(net.minecraft.world.entity.player.Player player, ItemStack stack, InteractionHand hand, @Nullable BlockSnapshot targetBlock, @Nullable net.minecraft.world.entity.Entity entity, CauseStackManager.StackFrame frame) {
        if (((PlatformEntityBridge)player).bridge$isFakePlayer()) {
            frame.addContext(EventContextKeys.FAKE_PLAYER, (Player)player);
        } else {
            frame.pushCause(player);
            frame.addContext(EventContextKeys.CREATOR, player.getUUID());
            frame.addContext(EventContextKeys.NOTIFIER, player.getUUID());
        }
        if (!stack.isEmpty()) {
            frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(stack));
        }
        frame.addContext(EventContextKeys.USED_HAND, (HandType)hand);
        if (targetBlock != null) {
            frame.addContext(EventContextKeys.BLOCK_HIT, targetBlock);
        }
        if (entity != null) {
            frame.addContext(EventContextKeys.ENTITY_HIT, (Entity)entity);
        }
    }

    public static void callNaturalMoveEntityEvent(net.minecraft.world.entity.Entity entity) {
        if (entity.isRemoved()) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entity);
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.NATURAL);
            Vector3d originalToPosition = ((Entity)entity).position();
            @Nullable Vector3d finalPosition = SpongeCommonEventFactory.callMoveEvent((Entity)entity, new Vector3d(entity.xOld, entity.yOld, entity.zOld), originalToPosition);
            if (finalPosition == null) {
                entity.moveTo(entity.xOld, entity.yOld, entity.zOld);
            } else if (!finalPosition.equals((Object)originalToPosition)) {
                entity.moveTo(finalPosition.x(), finalPosition.y(), finalPosition.z());
            }
        }
    }

    public static void callNaturalRotateEntityEvent(net.minecraft.world.entity.Entity entity) {
        if (entity.isRemoved() || entity.getXRot() == entity.xRotO && entity.getYRot() == entity.yRotO) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entity);
            @Nullable Vector3d finalRotation = SpongeCommonEventFactory.callRotateEvent((Entity)entity, new Vector3d(entity.yRotO, entity.xRotO, 0.0f), new Vector3d(entity.getYRot(), entity.getXRot(), 0.0f));
            if (finalRotation == null) {
                entity.setXRot(entity.xRotO);
                entity.setYRot(entity.yRotO);
            } else {
                entity.setXRot((float)finalRotation.y());
                entity.setYRot((float)finalRotation.x());
            }
        }
    }

    public static @Nullable Vector3d callMoveEvent(Entity movingEntity, Vector3d fromPosition, Vector3d toPosition) {
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        if (ShouldFire.MOVE_ENTITY_EVENT && fromPosition != null && toPosition != null && !fromPosition.mul(8.0).toInt().equals((Object)toPosition.mul(8.0).toInt())) {
            MoveEntityEvent event = SpongeEventFactory.createMoveEntityEvent(cause, movingEntity, fromPosition, toPosition, toPosition);
            if (SpongeCommon.post(event)) {
                return null;
            }
            return event.destinationPosition();
        }
        return toPosition;
    }

    public static @Nullable Vector3d callRotateEvent(Entity movingEntity, Vector3d fromRotation, Vector3d toRotation) {
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        if (ShouldFire.ROTATE_ENTITY_EVENT && fromRotation != null && toRotation != null && !fromRotation.mul(20.0).toInt().equals((Object)toRotation.mul(20.0).toInt())) {
            RotateEntityEvent event = SpongeEventFactory.createRotateEntityEvent(cause, movingEntity, fromRotation, toRotation);
            if (SpongeCommon.post(event)) {
                return null;
            }
            return event.toRotation();
        }
        return toRotation;
    }

    public static DestructEntityEvent.Death callDestructEntityEventDeath(LivingEntity entity, @Nullable DamageSource source) {
        return SpongeCommonEventFactory.callDestructEntityEventDeath(entity, source, Audience.empty());
    }

    public static DestructEntityEvent.Death callDestructEntityEventDeath(LivingEntity entity, @Nullable DamageSource source, Audience originalChannel) {
        net.minecraft.world.entity.Entity entity2;
        Optional<Object> sourceCreator = Optional.empty();
        boolean messageCancelled = false;
        if (source != null && (entity2 = source.getDirectEntity()) instanceof CreatorTrackedBridge) {
            CreatorTrackedBridge creatorBridge = (CreatorTrackedBridge)entity2;
            sourceCreator = creatorBridge.tracker$getCreatorUUID();
        }
        Component originalMessage = SpongeAdventure.asAdventure(entity.getCombatTracker().getDeathMessage());
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            if (source != null) {
                frame.pushCause(source);
            }
            sourceCreator.ifPresent(user -> frame.addContext(EventContextKeys.CREATOR, user));
            DestructEntityEvent.Death event = SpongeEventFactory.createDestructEntityEventDeath(frame.currentCause(), originalChannel, Optional.of(originalChannel), originalMessage, originalMessage, (Living)entity, entity.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY), false);
            SpongeCommon.post(event);
            DestructEntityEvent.Death death = event;
            return death;
        }
    }

    public static boolean handleCollideBlockEvent(Block block, Level world, BlockPos pos, BlockState state, net.minecraft.world.entity.Entity entity, Direction direction, CollisionType type) {
        if (world.isClientSide) {
            return false;
        }
        if (world.isClientSide() || pos.getY() < world.getMinBuildHeight()) {
            return false;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            EntityBridge spongeEntity;
            frame.pushCause(entity);
            if (entity instanceof CreatorTrackedBridge) {
                CreatorTrackedBridge spongeEntity2 = (CreatorTrackedBridge)entity;
                spongeEntity2.tracker$getCreatorUUID().ifPresent(user -> frame.addContext(EventContextKeys.CREATOR, user));
            }
            ServerLocation loc = ServerLocation.of((ServerWorld)world, VecHelper.toVector3d(pos));
            boolean cancelled = SpongeCommon.post(switch (type) {
                case CollisionType.MOVE -> SpongeEventFactory.createCollideBlockEventMove(frame.currentCause(), (org.spongepowered.api.block.BlockState)state, loc, direction);
                case CollisionType.FALL -> SpongeEventFactory.createCollideBlockEventFall(frame.currentCause(), (org.spongepowered.api.block.BlockState)state, loc, direction);
                case CollisionType.STEP_ON -> SpongeEventFactory.createCollideBlockEventStepOn(frame.currentCause(), (org.spongepowered.api.block.BlockState)state, loc, direction);
                case CollisionType.INSIDE -> SpongeEventFactory.createCollideBlockEventInside(frame.currentCause(), (org.spongepowered.api.block.BlockState)state, loc, direction);
                default -> throw new IllegalArgumentException("Unknown type " + type);
            });
            if (!cancelled && !pos.equals((Object)(spongeEntity = (EntityBridge)entity).bridge$getLastCollidedBlockPos())) {
                PhaseContext<?> context = PhaseTracker.getInstance().getPhaseContext();
                context.applyNotifierIfAvailable(notifier -> {
                    LevelChunkBridge spongeChunk = (LevelChunkBridge)world.getChunkAt(pos);
                    spongeChunk.bridge$addTrackedBlockPosition(block, pos, (UUID)notifier, PlayerTracker.Type.NOTIFIER);
                });
            }
            boolean bl = cancelled;
            return bl;
        }
    }

    public static boolean handleCollideImpactEvent(net.minecraft.world.entity.Entity projectile, @Nullable ProjectileSource projectileSource, HitResult movingObjectPosition) {
        HitResult.Type movingObjectType = movingObjectPosition.getType();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(projectile);
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, projectileSource == null ? UnknownProjectileSource.UNKNOWN : projectileSource);
            Optional<UUID> creator = PhaseTracker.getInstance().getPhaseContext().getCreator();
            creator.ifPresent(user -> frame.addContext(EventContextKeys.CREATOR, user));
            ServerLocation impactPoint = ServerLocation.of((ServerWorld)projectile.level(), VecHelper.toVector3d(movingObjectPosition.getLocation()));
            boolean cancelled = false;
            if (movingObjectType == HitResult.Type.BLOCK) {
                BlockHitResult blockMovingObjectPosition = (BlockHitResult)movingObjectPosition;
                BlockPos blockPos = blockMovingObjectPosition.getBlockPos();
                if (blockPos.getY() < projectile.level().getMinBuildHeight()) {
                    boolean bl = false;
                    return bl;
                }
                BlockSnapshot targetBlock = ((ServerWorld)projectile.level()).createSnapshot(blockPos.getX(), blockPos.getY(), blockPos.getZ());
                Direction side = DirectionFacingProvider.INSTANCE.getKey(blockMovingObjectPosition.getDirection()).get();
                CollideBlockEvent.Impact event = SpongeEventFactory.createCollideBlockEventImpact(frame.currentCause(), impactPoint, targetBlock.state(), targetBlock.location().get(), side);
                cancelled = SpongeCommon.post(event);
                if (!cancelled && creator.isPresent()) {
                    BlockPos targetPos = VecHelper.toBlockPos(impactPoint.blockPosition());
                    LevelChunkBridge spongeChunk = (LevelChunkBridge)projectile.level().getChunkAt(targetPos);
                    spongeChunk.bridge$addTrackedBlockPosition((Block)targetBlock.state().type(), targetPos, creator.get(), PlayerTracker.Type.NOTIFIER);
                }
            } else if (movingObjectType == HitResult.Type.ENTITY) {
                EntityHitResult entityMovingObjectPosition = (EntityHitResult)movingObjectPosition;
                ArrayList<Entity> entityList = new ArrayList<Entity>();
                entityList.add((Entity)entityMovingObjectPosition.getEntity());
                CollideEntityEvent.Impact event = SpongeEventFactory.createCollideEntityEventImpact(frame.currentCause(), entityList, impactPoint);
                cancelled = SpongeCommon.post(event);
            }
            boolean bl = cancelled;
            return bl;
        }
    }

    public static SetAITargetEvent callSetAttackTargetEvent(@Nullable Entity target, Agent agent) {
        SetAITargetEvent event = SpongeEventFactory.createSetAITargetEvent(PhaseTracker.getCauseStackManager().currentCause(), agent, Optional.ofNullable(target));
        SpongeCommon.post(event);
        return event;
    }

    public static Optional<net.minecraft.world.level.Explosion> detonateExplosive(ExplosiveBridge explosiveBridge, Explosion.Builder builder) {
        DetonateExplosiveEvent event = SpongeEventFactory.createDetonateExplosiveEvent(PhaseTracker.getCauseStackManager().currentCause(), builder, (Explosive)((Object)explosiveBridge), builder.build());
        if (!Sponge.eventManager().post(event)) {
            Explosion explosion = event.explosionBuilder().build();
            if (explosion.radius() > 0.0f) {
                ((TrackedWorldBridge)((Object)((Explosive)((Object)explosiveBridge)).world())).tracker$triggerInternalExplosion(explosion, e -> GeneralPhase.State.EXPLOSION.createPhaseContext(PhaseTracker.SERVER).explosion((net.minecraft.world.level.Explosion)e));
            }
            return Optional.of((net.minecraft.world.level.Explosion)explosion);
        }
        return Optional.empty();
    }

    public static @Nullable ItemStack throwDropItemAndConstructEvent(net.minecraft.world.entity.Entity entity, double posX, double posY, double posZ, ItemStackSnapshot snapshot, List<ItemStackSnapshot> original, CauseStackManager.StackFrame frame) {
        ItemStack item;
        frame.pushCause(entity);
        DropItemEvent.Pre dropEvent = SpongeEventFactory.createDropItemEventPre(frame.currentCause(), (List<ItemStackSnapshot>)ImmutableList.of((Object)snapshot), original);
        SpongeCommon.post(dropEvent);
        if (dropEvent.isCancelled()) {
            return null;
        }
        if (dropEvent.droppedItems().isEmpty()) {
            return null;
        }
        frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
        ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(frame.currentCause(), ServerLocation.of((ServerWorld)entity.level(), posX, posY, posZ), new Vector3d(0.0f, 0.0f, 0.0f), EntityTypes.ITEM.get());
        frame.removeContext(EventContextKeys.SPAWN_TYPE);
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            return null;
        }
        ItemStack itemStack = item = event.isCancelled() ? null : ItemStackUtil.fromSnapshotToNative(dropEvent.droppedItems().get(0));
        if (item == null) {
            return null;
        }
        return item;
    }

    public static  @Nullable PlaySoundEvent.Broadcast callPlaySoundBroadcastEvent(CauseStackManager.StackFrame frame, LevelBridge bridge, BlockPos pos, int effectID) {
        float volume;
        DefaultedRegistryReference<SoundType> soundType;
        if (effectID == 1023) {
            soundType = SoundTypes.ENTITY_WITHER_SPAWN;
            volume = 1.0f;
        } else if (effectID == 1028) {
            soundType = SoundTypes.ENTITY_ENDER_DRAGON_DEATH;
            volume = 5.0f;
        } else if (effectID == 1038) {
            soundType = SoundTypes.BLOCK_END_PORTAL_SPAWN;
            volume = 1.0f;
        } else {
            return null;
        }
        ServerLocation location = ServerLocation.of((ServerWorld)((Object)bridge), pos.getX(), pos.getY(), pos.getZ());
        PlaySoundEvent.Broadcast event = SpongeEventFactory.createPlaySoundEventBroadcast(frame.currentCause(), location, Sound.Source.HOSTILE, (SoundType)soundType.get(), 1.0f, volume);
        SpongeCommon.post(event);
        return event;
    }

    public static PlaySoundEvent.FromJukebox callPlaySoundFromJukeboxEvent(Cause cause, JukeboxBlockEntity jukebox, MusicDisc recordType, int data) {
        Jukebox apiJuke = (Jukebox)jukebox;
        ServerLocation location = (ServerLocation)apiJuke.location();
        PlaySoundEvent.FromJukebox event = data == 0 ? SpongeEventFactory.createPlaySoundEventFromJukeboxStart(cause, apiJuke, location, recordType, Sound.Source.RECORD, recordType.sound(), 1.0f, 4.0f) : SpongeEventFactory.createPlaySoundEventFromJukeboxStop(cause, apiJuke, location, recordType, Sound.Source.RECORD, recordType.sound(), 1.0f, 4.0f);
        SpongeCommon.post(event);
        return event;
    }

    public static PlaySoundEvent.AtEntity callPlaySoundAtEntityEvent(Cause cause, @Nullable net.minecraft.world.entity.player.Player entity, LevelBridge worldMixin, double x, double y, double z, SoundSource category, SoundEvent name, float pitch, float volume) {
        ServerLocation location = ServerLocation.of((ServerWorld)((Object)worldMixin), x, y, z);
        PlaySoundEvent.AtEntity event = SpongeEventFactory.createPlaySoundEventAtEntity(cause, location, Optional.ofNullable((ServerPlayer)entity), SpongeAdventure.asAdventure(category), (SoundType)name, pitch, volume);
        SpongeCommon.post(event);
        return event;
    }

    public static PlaySoundEvent.NoteBlock callPlaySoundNoteBlockEvent(Cause cause, World world, BlockPos pos, SoundEvent soundEvent, InstrumentType instrument, NotePitch notePitch, Float pitch) {
        ServerLocation location = ServerLocation.of((ServerWorld)world, pos.getX(), pos.getY(), pos.getZ());
        PlaySoundEvent.NoteBlock event = SpongeEventFactory.createPlaySoundEventNoteBlock(cause, instrument, location, notePitch, Sound.Source.RECORD, (SoundType)soundEvent, pitch.floatValue(), 3.0f);
        SpongeCommon.post(event);
        return event;
    }

    public static Optional<MapInfo> fireCreateMapEvent(Cause cause) {
        return SpongeCommonEventFactory.fireCreateMapEvent(cause, Collections.emptySet());
    }

    public static Optional<MapInfo> fireCreateMapEvent(Cause cause, Set<Value<?>> values) {
        int mcId;
        ServerLevel defaultWorld = (ServerLevel)Sponge.server().worldManager().world(DefaultWorldKeys.DEFAULT).get();
        MapIdTrackerBridge mapIdTrackerBridge = (MapIdTrackerBridge)defaultWorld.getDataStorage().computeIfAbsent(MapIndex.factory(), "idcounts");
        MapItemSavedData mapData = MapItemSavedData.createFresh((double)0.0, (double)0.0, (byte)0, (boolean)false, (boolean)false, (ResourceKey)Level.END);
        MapInfo mapInfo = (MapInfo)mapData;
        for (Value<?> value : values) {
            mapInfo.offer(value);
        }
        CreateMapEvent event = SpongeEventFactory.createCreateMapEvent(cause, mapInfo);
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            return Optional.empty();
        }
        int id = mapIdTrackerBridge.bridge$getHighestMapId().orElse(-1) + 1;
        if (id != (mcId = defaultWorld.getFreeMapId())) {
            SpongeCommon.logger().warn("Map size corruption, vanilla only allows 2147483647! Expected next number was not equal to the true next number.");
            SpongeCommon.logger().warn("Expected: " + id + ". Got: " + mcId);
            SpongeCommon.logger().warn("Automatically cancelling map creation");
            mapIdTrackerBridge.bridge$setHighestMapId(id - 1);
            return Optional.empty();
        }
        String mapId = MapItem.makeKey((int)id);
        defaultWorld.setMapData(mapId, mapData);
        ((MapItemSavedDataBridge)mapData).bridge$initMapId(id);
        ((SpongeMapStorage)Sponge.server().mapStorage()).addMapInfo(mapInfo);
        return Optional.of(mapInfo);
    }

    public static enum CollisionType {
        MOVE,
        FALL,
        STEP_ON,
        INSIDE;

    }
}

