/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.filter.delegate;

import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.filter.IsCancelled;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.event.filter.delegate.FilterDelegate;
import org.spongepowered.common.event.manager.ListenerClassVisitor;

public class CancellationEventFilterDelegate
implements FilterDelegate {
    private final Tristate state;

    public CancellationEventFilterDelegate(IsCancelled state) {
        this(state.value());
    }

    public CancellationEventFilterDelegate(Tristate state) {
        this.state = state;
    }

    @Override
    public int write(String name, ClassWriter cw, MethodVisitor mv, ListenerClassVisitor.DiscoveredMethod method, int locals) throws ClassNotFoundException {
        if (this.state == Tristate.UNDEFINED) {
            return locals;
        }
        boolean checkCancellable = !Cancellable.class.isAssignableFrom(method.parameterTypes()[0].clazz());
        String cancellableClassName = Type.getInternalName(Cancellable.class);
        Label notCancelled = new Label();
        if (checkCancellable) {
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(193, cancellableClassName);
            mv.visitJumpInsn(153, notCancelled);
        }
        mv.visitVarInsn(25, 1);
        if (checkCancellable) {
            mv.visitTypeInsn(192, cancellableClassName);
        }
        mv.visitMethodInsn(185, cancellableClassName, "isCancelled", "()Z", true);
        if (this.state == Tristate.TRUE) {
            Label cancelled = new Label();
            mv.visitJumpInsn(154, cancelled);
            if (checkCancellable) {
                mv.visitLabel(notCancelled);
            }
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitLabel(cancelled);
        } else {
            mv.visitJumpInsn(153, notCancelled);
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitLabel(notCancelled);
        }
        return locals;
    }
}

