/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.DeepIterator;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.ReverseDeepIterator;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;

public class ResultingTransactionBySideEffect {
    public final ProcessingSideEffect effect;
    @Nullable GameTransaction<@NonNull ?> head;
    @Nullable GameTransaction<@NonNull ?> tail;

    public ResultingTransactionBySideEffect(ProcessingSideEffect effect) {
        this.effect = effect;
    }

    public void addChild(PhaseContext<@NonNull ?> context, GameTransaction<@NonNull ?> child) {
        Optional<TransactionFlow.AbsorbingFlowStep> absorbingFlowStep = child.parentAbsorber();
        if (absorbingFlowStep.isPresent()) {
            TransactionFlow.AbsorbingFlowStep absorber = absorbingFlowStep.get();
            Iterator<GameTransaction<@NonNull ?>> iterator = this.reverseDeepIterator();
            while (iterator.hasNext()) {
                if (!absorber.absorb(context, iterator.next())) continue;
                return;
            }
        }
        if (this.tail != null) {
            this.tail.append(child);
        } else {
            this.head = child;
        }
        this.tail = child;
    }

    public Iterator<GameTransaction<@NonNull ?>> deepIterator() {
        return this.head != null ? new DeepIterator(this.head) : Collections.emptyIterator();
    }

    public Iterator<GameTransaction<@NonNull ?>> reverseDeepIterator() {
        return this.tail != null ? new ReverseDeepIterator(this.tail) : Collections.emptyIterator();
    }
}

