/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class NotifyClientEffect
implements ProcessingSideEffect {
    public static NotifyClientEffect getInstance() {
        return Holder.INSTANCE;
    }

    NotifyClientEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        LevelChunk chunk = pipeline.getAffectedChunk();
        ServerLevel world = pipeline.getServerWorld();
        if (flag.notifyClients() && chunk.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING)) {
            world.sendBlockUpdated(oldState.pos, oldState.state, newState, flag.getRawFlag());
        }
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final NotifyClientEffect INSTANCE = new NotifyClientEffect();

        private Holder() {
        }
    }
}

