/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.generation;

import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ticks.ScheduledTick;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.GeneralGenerationPhaseState;
import org.spongepowered.common.event.tracking.phase.generation.GenerationContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;

final class DeferredScheduledUpdatePhaseState
extends GeneralGenerationPhaseState<Context> {
    private final BiConsumer<CauseStackManager.StackFrame, Context> CHUNK_LOAD_MODIFIER = super.getFrameModifier().andThen((frame, context) -> frame.pushCause(context.location()));

    public DeferredScheduledUpdatePhaseState() {
        super("CHUNK_LOAD");
    }

    @Override
    public Context createNewContext(PhaseTracker tracker) {
        return new Context(tracker);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, Context> getFrameModifier() {
        return this.CHUNK_LOAD_MODIFIER;
    }

    @Override
    public void associateScheduledTickUpdate(Context asContext, ServerLevel level, ScheduledTick<?> entry) {
    }

    public static final class Context
    extends GenerationContext<Context> {
        private BlockPos location;
        private Object type;

        Context(PhaseTracker tracker) {
            super(GenerationPhase.State.DEFERRED_SCHEDULED_UPDATE, tracker);
        }

        public Context scheduledUpdate(BlockPos location, Object type) {
            this.location = location;
            this.type = type;
            return this;
        }

        public BlockPos location() {
            return Objects.requireNonNull(this.location, "NextTickListEntry was not initialized");
        }

        public Object type() {
            return Objects.requireNonNull(this.type, "NextTickListEntry was not initialized");
        }
    }
}

