/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.fluid;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.fluid.FluidStack;
import org.spongepowered.api.fluid.FluidStackSnapshot;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.fluid.SpongeFluidStackSnapshot;
import org.spongepowered.common.util.Constants;

public final class SpongeFluidStackSnapshotBuilder
extends AbstractDataBuilder<FluidStackSnapshot>
implements FluidStackSnapshot.Builder {
    FluidType fluidType;
    int volume;
    @Nullable DataView container;
    @Nullable LinkedHashMap<Key<@NonNull ?>, Object> keyValues;

    public SpongeFluidStackSnapshotBuilder() {
        super(FluidStackSnapshot.class, 1);
    }

    @Override
    public @NonNull FluidStackSnapshot.Builder fluid(@NonNull FluidType fluidType) {
        this.fluidType = Objects.requireNonNull(fluidType, "FluidType cannot be null!");
        return this;
    }

    @Override
    public @NonNull FluidStackSnapshot.Builder volume(int volume) {
        this.volume = volume;
        return this;
    }

    @Override
    public @NonNull FluidStackSnapshot.Builder from(@NonNull FluidStack fluidStack) {
        this.fluidType = fluidStack.fluid();
        this.volume = fluidStack.volume();
        DataContainer datacontainer = fluidStack.toContainer();
        this.container = null;
        if (datacontainer.contains(Constants.Sponge.UNSAFE_NBT)) {
            this.container = datacontainer.getView(Constants.Sponge.UNSAFE_NBT).get();
        }
        return this;
    }

    @Override
    public @NonNull FluidStackSnapshot.Builder from(@NonNull FluidStackSnapshot holder) {
        Objects.requireNonNull(holder, "FluidStackSnapshot cannot be null!");
        if (!(holder instanceof SpongeFluidStackSnapshot)) {
            throw new IllegalArgumentException("Must be a SpongeFluidStackSnapshot");
        }
        this.fluidType = Objects.requireNonNull(holder.fluid(), "Invalid FluidStackSnapshot! FluidType cannot be null!");
        this.container = holder.toContainer();
        this.keyValues = new LinkedHashMap(((SpongeFluidStackSnapshot)holder).impl$getMappedValues());
        return this;
    }

    public FluidStackSnapshot build() {
        if (this.fluidType == null) {
            throw new IllegalStateException("FluidType cannot be null!");
        }
        if (this.volume < 0) {
            throw new IllegalStateException("The fluid volume must be at least 0!");
        }
        SpongeFluidStackSnapshot snapshot = new SpongeFluidStackSnapshot(this);
        if (this.keyValues != null) {
            FluidStack stack = snapshot.createStack();
            this.keyValues.forEach((k, v) -> stack.offer(k, v));
            return stack.createSnapshot();
        }
        return snapshot;
    }

    @Override
    protected @NonNull Optional<FluidStackSnapshot> buildContent(@NonNull DataView container) throws InvalidDataException {
        try {
            if (container.contains(Constants.Fluids.FLUID_TYPE, Constants.Fluids.FLUID_VOLUME)) {
                String rawFluid = container.getString(Constants.Fluids.FLUID_TYPE).get();
                Optional type = Sponge.game().registry(RegistryTypes.FLUID_TYPE).findValue(ResourceKey.resolve(rawFluid));
                if (!type.isPresent()) {
                    throw new InvalidDataException("Unknown fluid id found: " + rawFluid);
                }
                FluidType fluidType = (FluidType)type.get();
                int volume = container.getInt(Constants.Fluids.FLUID_VOLUME).get();
                SpongeFluidStackSnapshotBuilder builder = new SpongeFluidStackSnapshotBuilder();
                builder.fluid(fluidType).volume(volume);
                if (container.contains(Constants.Sponge.UNSAFE_NBT)) {
                    builder.container = container.getView(Constants.Sponge.UNSAFE_NBT).get().copy();
                }
                return Optional.of(builder.build());
            }
        }
        catch (Exception e) {
            throw new InvalidDataException("Something went wrong deserializing.", e);
        }
        return Optional.empty();
    }

    @Override
    public @NonNull FluidStackSnapshot.Builder reset() {
        this.fluidType = null;
        this.volume = 0;
        this.container = null;
        return this;
    }

    @Override
    public <V> @NonNull FluidStackSnapshot.Builder add(@NonNull Key<@NonNull ? extends Value<V>> key, @NonNull V value) {
        if (this.keyValues == null) {
            this.keyValues = new LinkedHashMap();
        }
        this.keyValues.put((Key)Preconditions.checkNotNull(key, (Object)"Key cannot be null!"), Preconditions.checkNotNull(value, (Object)"Value cannot be null!"));
        return this;
    }
}

