/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.query.Query;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.inventory.EmptyInventoryImpl;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.DelegatingLens;
import org.spongepowered.common.inventory.lens.impl.LensRegistrar;
import org.spongepowered.common.inventory.lens.impl.QueryLens;
import org.spongepowered.common.inventory.lens.impl.slot.QueriedSlotLens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;

public abstract class SpongeQuery
implements Query {
    @Override
    public Inventory execute(Inventory inventory) {
        if (!(inventory instanceof InventoryBridge)) {
            throw new IllegalArgumentException("Unsupported Inventory! " + inventory.getClass().getName());
        }
        return this.execute(inventory, ((InventoryBridge)((Object)inventory)).bridge$getAdapter());
    }

    public abstract Inventory execute(Inventory var1, InventoryAdapter var2);

    protected Map<Lens, Integer> reduce(Fabric fabric, Lens lens, Map<Lens, Integer> matches) {
        if (matches.isEmpty()) {
            return Collections.emptyMap();
        }
        List<Lens> lensSlots = lens.getChildren();
        if (lensSlots.size() == matches.size() && matches.keySet().containsAll(lensSlots)) {
            matches.clear();
            matches.put(lens, 0);
            return matches;
        }
        LinkedHashMap<SlotLens, Map> lenses = new LinkedHashMap<SlotLens, Map>();
        HashMap<Lens, Integer> toRemove = new HashMap<Lens, Integer>();
        for (Map.Entry<Lens, Integer> entry : matches.entrySet()) {
            Lens slotLens = entry.getKey();
            if (slotLens.slotCount() != 1) continue;
            toRemove.put(slotLens, matches.get(slotLens));
            SlotLens sl = slotLens.getSlotLens(fabric, 0);
            Lens parent = slotLens.getParent();
            Map dataAt = parent == null ? Collections.emptyMap() : parent.getDataFor(slotLens);
            lenses.computeIfAbsent(sl, k -> new HashMap()).putAll(dataAt);
        }
        matches.keySet().removeAll(toRemove.keySet());
        for (Map.Entry<Lens, Integer> entry : lenses.entrySet()) {
            Map data = (Map)((Object)entry.getValue());
            if (data.isEmpty()) {
                matches.put(entry.getKey(), toRemove.getOrDefault(entry.getKey(), 0));
                continue;
            }
            QueriedSlotLens delegatingSlotLens = new QueriedSlotLens((SlotLens)entry.getKey(), data);
            matches.put(delegatingSlotLens, toRemove.getOrDefault(entry.getKey(), 0));
        }
        return matches;
    }

    protected Inventory toResult(Inventory inventory, Fabric fabric, Map<Lens, Integer> matches) {
        if (matches.isEmpty()) {
            return new EmptyInventoryImpl(inventory);
        }
        if (matches.size() == 1) {
            Map.Entry<Lens, Integer> entry = matches.entrySet().iterator().next();
            if (entry.getValue() == 0) {
                return entry.getKey().getAdapter(fabric, inventory);
            }
            LensRegistrar.BasicSlotLensProvider slotProvider = new LensRegistrar.BasicSlotLensProvider(entry.getKey().slotCount());
            DelegatingLens delegate = new DelegatingLens((int)entry.getValue(), entry.getKey(), slotProvider);
            return delegate.getAdapter(fabric, inventory);
        }
        QueryLens lens = new QueryLens(matches, this);
        return lens.getAdapter(fabric, inventory);
    }
}

