/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.spongepowered.common.item.recipe.cooking.ResultFunctionRecipe;

public class SpongeCookingRecipeSerializer<R extends AbstractCookingRecipe>
implements RecipeSerializer<R> {
    private CookingRecipeFactory<R> factory;
    private Codec<R> codec;
    private final int defaultCookingTime;

    public SpongeCookingRecipeSerializer(CookingRecipeFactory<R> factory, int defaultCookingTime) {
        this.defaultCookingTime = defaultCookingTime;
        this.factory = factory;
        this.codec = RecordCodecBuilder.create($$2 -> $$2.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(rec$ -> ((AbstractCookingRecipe)rec$).getGroup()), (App)CookingBookCategory.CODEC.fieldOf("category").orElse((Object)CookingBookCategory.MISC).forGetter(rec$ -> ((AbstractCookingRecipe)rec$).category()), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter($$0x -> (Ingredient)$$0x.getIngredients().get(0)), (App)BuiltInRegistries.ITEM.byNameCodec().xmap(ItemStack::new, ItemStack::getItem).fieldOf("result").forGetter($$0x -> $$0x.getResultItem(null)), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(rec$ -> Float.valueOf(((AbstractCookingRecipe)rec$).getExperience())), (App)Codec.INT.fieldOf("cookingtime").orElse((Object)defaultCookingTime).forGetter(rec$ -> ((AbstractCookingRecipe)rec$).getCookingTime()), (App)ItemStack.CODEC.optionalFieldOf("sponge:result", (Object)ItemStack.EMPTY).forGetter(raw -> raw.getResultItem(null).hasTag() ? raw.getResultItem(null) : ItemStack.EMPTY), (App)Codec.STRING.optionalFieldOf("sponge:result_function", null).forGetter(rec$ -> ((ResultFunctionRecipe)rec$).resultFunctionId())).apply((Applicative)$$2, factory::create));
    }

    public Codec<R> codec() {
        return this.codec;
    }

    public R fromNetwork(FriendlyByteBuf var1) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }

    public void toNetwork(FriendlyByteBuf buffer, R recipe) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }

    static interface CookingRecipeFactory<T extends AbstractCookingRecipe> {
        default public T create(String group, CookingBookCategory category, Ingredient ingredient, ItemStack result, float experience, int cookingTime, ItemStack spongeResult, String resultFunctionId) {
            return this.create(group, category, ingredient, spongeResult.isEmpty() ? result : spongeResult, experience, cookingTime, resultFunctionId);
        }

        public T create(String var1, CookingBookCategory var2, Ingredient var3, ItemStack var4, float var5, int var6, String var7);
    }
}

