/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.spongepowered.common.item.recipe.cooking.SpongeBlastingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeCampfireCookingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeCookingRecipeSerializer;
import org.spongepowered.common.item.recipe.cooking.SpongeFurnaceRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeSmokingRecipe;
import org.spongepowered.common.item.recipe.crafting.custom.SpongeSpecialCraftingRecipeRegistration;
import org.spongepowered.common.item.recipe.crafting.custom.SpongeSpecialCraftingRecipeSerializer;
import org.spongepowered.common.item.recipe.crafting.custom.SpongeSpecialRecipe;
import org.spongepowered.common.item.recipe.crafting.shaped.SpongeShapedCraftingRecipeSerializer;
import org.spongepowered.common.item.recipe.crafting.shapeless.SpongeShapelessCraftingRecipeSerializer;
import org.spongepowered.common.item.recipe.smithing.SpongeSmithingRecipe;
import org.spongepowered.common.item.recipe.smithing.SpongeSmithingRecipeSerializer;
import org.spongepowered.common.item.recipe.stonecutting.SpongeStonecuttingRecipe;
import org.spongepowered.common.item.recipe.stonecutting.SpongeStonecuttingRecipeSerializer;

public interface SpongeRecipeSerializers {
    public static final SpongeCookingRecipeSerializer<SpongeBlastingRecipe> SPONGE_BLASTING = SpongeRecipeSerializers.register("blasting", new SpongeCookingRecipeSerializer<SpongeBlastingRecipe>(SpongeBlastingRecipe::new, 100));
    public static final SpongeCookingRecipeSerializer<SpongeCampfireCookingRecipe> SPONGE_CAMPFIRE_COOKING = SpongeRecipeSerializers.register("campfire_cooking", new SpongeCookingRecipeSerializer<SpongeCampfireCookingRecipe>(SpongeCampfireCookingRecipe::new, 100));
    public static final SpongeCookingRecipeSerializer<SpongeFurnaceRecipe> SPONGE_SMELTING = SpongeRecipeSerializers.register("smelting", new SpongeCookingRecipeSerializer<SpongeFurnaceRecipe>(SpongeFurnaceRecipe::new, 200));
    public static final RecipeSerializer<?> SPONGE_CRAFTING_SHAPED = SpongeRecipeSerializers.register("crafting_shaped", new SpongeShapedCraftingRecipeSerializer());
    public static final RecipeSerializer<?> SPONGE_CRAFTING_SHAPELESS = SpongeRecipeSerializers.register("crafting_shapeless", new SpongeShapelessCraftingRecipeSerializer());
    public static final RecipeSerializer<?> SPONGE_SMITHING = SpongeRecipeSerializers.register("smithing", new SpongeSmithingRecipeSerializer<SpongeSmithingRecipe>(SpongeSmithingRecipe::new));
    public static final RecipeSerializer<?> SPONGE_STONECUTTING = SpongeRecipeSerializers.register("stonecutting", new SpongeStonecuttingRecipeSerializer<SpongeStonecuttingRecipe>(SpongeStonecuttingRecipe::new));
    public static final SpongeCookingRecipeSerializer<SpongeSmokingRecipe> SPONGE_SMOKING = SpongeRecipeSerializers.register("smoking", new SpongeCookingRecipeSerializer<SpongeSmokingRecipe>(SpongeSmokingRecipe::new, 100));
    public static final SpongeSpecialCraftingRecipeSerializer<SpongeSpecialRecipe> SPONGE_SPECIAL = SpongeRecipeSerializers.register("special", new SpongeSpecialCraftingRecipeSerializer<SpongeSpecialRecipe>(SpongeSpecialCraftingRecipeRegistration::get));

    public static <S extends RecipeSerializer<T>, T extends Recipe<?>> S register(String spongeName, S recipeSerializer) {
        return (S)((RecipeSerializer)Registry.register((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)new ResourceLocation("sponge", spongeName).toString(), recipeSerializer));
    }

    public static <S extends RecipeSerializer<T>, T extends Recipe<?>> S register(ResourceLocation resourceLocation, S recipeSerializer) {
        return (S)((RecipeSerializer)Registry.register((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)resourceLocation.toString(), recipeSerializer));
    }
}

