/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shapeless;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;

public class SpongeShapelessRecipe
extends ShapelessRecipe {
    private final boolean onlyVanillaIngredients;
    private final String resultFunctionId;
    private final String remainingItemsFunctionId;

    public SpongeShapelessRecipe(String groupIn, CraftingBookCategory category, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn, ItemStack spongeResultStack, Optional<String> resultFunctionId, Optional<String> remainingItemsFunctionId) {
        super(groupIn, category, spongeResultStack.isEmpty() ? recipeOutputIn : spongeResultStack, recipeItemsIn);
        this.onlyVanillaIngredients = recipeItemsIn.stream().noneMatch(i -> i instanceof SpongeIngredient);
        this.resultFunctionId = resultFunctionId.orElse(null);
        this.remainingItemsFunctionId = remainingItemsFunctionId.orElse(null);
    }

    public Optional<String> resultFunctionId() {
        return Optional.ofNullable(this.resultFunctionId);
    }

    public Optional<String> remainingItemsFunctionId() {
        return Optional.ofNullable(this.remainingItemsFunctionId);
    }

    public boolean matches(CraftingContainer inv, Level p_77569_2_) {
        if (this.onlyVanillaIngredients) {
            return super.matches(inv, p_77569_2_);
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.getContainerSize(); ++j) {
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.isEmpty()) continue;
            items.add(itemstack);
        }
        return SpongeShapelessRecipe.matches(items, (List<Ingredient>)this.getIngredients());
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        if (this.remainingItemsFunctionId != null) {
            return IngredientResultUtil.cachedRemainingItemsFunction(this.remainingItemsFunctionId).apply(inv);
        }
        return super.getRemainingItems((Container)inv);
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess $$1) {
        if (this.resultFunctionId != null) {
            return IngredientResultUtil.cachedResultFunction(this.resultFunctionId).apply(container);
        }
        return super.assemble(container, $$1);
    }

    public ItemStack getResultItem(RegistryAccess $$1) {
        if (this.resultFunctionId != null) {
            return ItemStack.EMPTY;
        }
        return super.getResultItem($$1);
    }

    private static boolean matches(List<ItemStack> stacks, List<Ingredient> ingredients) {
        int elements = ingredients.size();
        if (stacks.size() != elements) {
            return false;
        }
        HashMap<Integer, List> matchesMap = new HashMap<Integer, List>();
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = ingredients.get(i);
            boolean noMatch = true;
            for (int j = 0; j < stacks.size(); ++j) {
                if (!ingredient.test(stacks.get(j))) continue;
                matchesMap.computeIfAbsent(j, k -> new ArrayList()).add(i);
                noMatch = false;
            }
            if (!noMatch) continue;
            return false;
        }
        if (matchesMap.isEmpty()) {
            return false;
        }
        ArrayList<Collection<Integer>> stackList = new ArrayList<Collection<Integer>>(matchesMap.values());
        stackList.sort(Comparator.comparingInt(Collection::size));
        return SpongeShapelessRecipe.matchesRecursive(stackList, 0, new HashSet<Integer>());
    }

    private static boolean matchesRecursive(List<Collection<Integer>> stackList, int d, Set<Integer> used) {
        if (d == stackList.size()) {
            return true;
        }
        Collection<Integer> stacks = stackList.get(d);
        for (Integer stack : stacks) {
            if (used.contains(stack)) continue;
            HashSet<Integer> copy = new HashSet<Integer>(used);
            copy.add(stack);
            if (!SpongeShapelessRecipe.matchesRecursive(stackList, d + 1, copy)) continue;
            return true;
        }
        return false;
    }
}

