/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.ingredient;

import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;
import org.spongepowered.common.item.util.ItemStackUtil;

public class IngredientUtil {
    public static org.spongepowered.api.item.recipe.crafting.Ingredient fromNative(Ingredient ingredient) {
        return (org.spongepowered.api.item.recipe.crafting.Ingredient)ingredient;
    }

    public static Ingredient toNative(org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) {
        return (Ingredient)ingredient;
    }

    public static org.spongepowered.api.item.recipe.crafting.Ingredient of(ItemType ... items) {
        ItemLike[] providers = (ItemLike[])Arrays.stream(items).map(item -> () -> (Item)item).toArray(ItemLike[]::new);
        return IngredientUtil.fromNative(Ingredient.of((ItemLike[])providers));
    }

    public static @Nullable org.spongepowered.api.item.recipe.crafting.Ingredient of(org.spongepowered.api.ResourceKey tagKey) {
        TagKey key = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)((ResourceLocation)tagKey));
        return IngredientUtil.fromNative(Ingredient.of((TagKey)key));
    }

    private static net.minecraft.world.item.ItemStack[] toNativeStacks(ItemStack[] stacks) {
        return (net.minecraft.world.item.ItemStack[])Arrays.stream(stacks).map(ItemStackUtil::toNative).toArray(net.minecraft.world.item.ItemStack[]::new);
    }

    public static org.spongepowered.api.item.recipe.crafting.Ingredient of(ItemStack ... stacks) {
        SpongeIngredient ingredient = SpongeIngredient.spongeFromStacks(IngredientUtil.toNativeStacks(stacks));
        return IngredientUtil.fromNative(ingredient);
    }

    public static org.spongepowered.api.item.recipe.crafting.Ingredient of(org.spongepowered.api.ResourceKey key, Predicate<ItemStack> predicate, ItemStack ... stacks) {
        SpongeIngredient ingredient = SpongeIngredient.spongeFromPredicate(key, predicate, IngredientUtil.toNativeStacks(stacks));
        return IngredientUtil.fromNative(ingredient);
    }
}

