/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smithing;

import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.item.recipe.cooking.ResultFunctionRecipe;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;

public class SpongeSmithingRecipe
extends SmithingTransformRecipe
implements ResultFunctionRecipe {
    private final String resultFunctionId;

    public SpongeSmithingRecipe(Ingredient template, Ingredient base, Ingredient addition, ItemStack resultIn, String resultFunctionId) {
        super(template, base, addition, resultIn);
        this.resultFunctionId = resultFunctionId;
    }

    @Override
    public @Nullable String resultFunctionId() {
        return this.resultFunctionId;
    }

    public ItemStack assemble(Container $$0, RegistryAccess $$1) {
        if (this.resultFunctionId != null) {
            return IngredientResultUtil.cachedResultFunction(this.resultFunctionId).apply($$0);
        }
        if (this.getResultItem($$1).hasTag()) {
            ItemStack itemStack = this.getResultItem($$1).copy();
            CompoundTag compoundnbt = $$0.getItem(0).getTag();
            if (compoundnbt != null) {
                CompoundTag merged = itemStack.getTag().merge(compoundnbt.copy());
                itemStack.setTag(merged);
                return itemStack;
            }
        }
        return super.assemble($$0, $$1);
    }

    public ItemStack getResultItem(RegistryAccess $$1) {
        if (this.resultFunctionId != null) {
            return ItemStack.EMPTY;
        }
        return super.getResultItem($$1);
    }
}

