/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smithing;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;

public class SpongeSmithingRecipeRegistration
extends SpongeRecipeRegistration {
    private final Ingredient base;
    private final Ingredient addition;
    private final Item result;
    private final ItemStack spongeResult;
    private Function<Container, ItemStack> resultFunction;

    public SpongeSmithingRecipeRegistration(ResourceLocation key, RecipeSerializer<?> serializer, String group, Ingredient base, Ingredient addition, ItemStack spongeResult, Function<Container, ItemStack> resultFunction, DataPack<RecipeRegistration> pack, RecipeCategory category) {
        super(key, serializer, spongeResult.getItem(), group, pack, category);
        this.base = base;
        this.addition = addition;
        this.result = spongeResult.getItem();
        this.spongeResult = spongeResult;
        this.resultFunction = resultFunction;
    }

    @Override
    public void serializeShape(JsonObject json) {
        json.add("base", this.base.toJson(false));
        json.add("addition", this.addition.toJson(false));
    }

    @Override
    public void serializeResult(JsonObject json) {
        JsonObject item = new JsonObject();
        DefaultedRegistry itemRegistry = BuiltInRegistries.ITEM;
        item.addProperty("item", itemRegistry.getKey((Object)this.result).toString());
        json.add("result", item);
        if (this.spongeResult != null) {
            json.add("sponge:result", IngredientResultUtil.serializeItemStack(this.spongeResult));
        }
        if (this.resultFunction != null) {
            json.addProperty("sponge:result_function", IngredientResultUtil.cacheResultFunction(this.id(), this.resultFunction));
        }
    }
}

