/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.stonecutting;

import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.item.recipe.cooking.ResultFunctionRecipe;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;

public class SpongeStonecuttingRecipe
extends StonecutterRecipe
implements ResultFunctionRecipe {
    private final String resultFunctionId;

    public SpongeStonecuttingRecipe(String groupIn, Ingredient ingredientIn, ItemStack resultIn, String resultFunctionId) {
        super(groupIn, ingredientIn, resultIn);
        this.resultFunctionId = resultFunctionId;
    }

    @Override
    public @Nullable String resultFunctionId() {
        return this.resultFunctionId;
    }

    public ItemStack assemble(Container container, RegistryAccess $$1) {
        if (this.resultFunctionId != null) {
            return IngredientResultUtil.cachedResultFunction(this.resultFunctionId).apply(container);
        }
        return super.assemble(container, $$1);
    }

    public ItemStack getResultItem(RegistryAccess $$1) {
        if (this.resultFunctionId != null) {
            return ItemStack.EMPTY;
        }
        return super.getResultItem($$1);
    }
}

