/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.stonecutting;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;

public class SpongeStonecuttingRecipeRegistration
extends SpongeRecipeRegistration {
    private final Ingredient ingredient;
    private final Item result;
    private final int count;
    private final ItemStack spongeResult;
    private Function<Container, ItemStack> resultFunction;

    public SpongeStonecuttingRecipeRegistration(ResourceLocation key, RecipeSerializer<?> serializer, String group, Ingredient ingredient, ItemStack spongeResult, Function<Container, ItemStack> resultFunction, DataPack<RecipeRegistration> pack, RecipeCategory category) {
        super(key, serializer, spongeResult.getItem(), group, pack, category);
        this.ingredient = ingredient;
        this.result = spongeResult.getItem();
        this.count = spongeResult.getCount();
        this.spongeResult = spongeResult;
        this.resultFunction = resultFunction;
    }

    @Override
    public void serializeShape(JsonObject json) {
        json.add("ingredient", this.ingredient.toJson(false));
    }

    @Override
    public void serializeResult(JsonObject json) {
        DefaultedRegistry itemRegistry = BuiltInRegistries.ITEM;
        json.addProperty("result", itemRegistry.getKey((Object)this.result).toString());
        json.addProperty("count", this.count);
        if (this.spongeResult != null) {
            json.add("sponge:result", IngredientResultUtil.serializeItemStack(this.spongeResult));
        }
        if (this.resultFunction != null) {
            json.addProperty("sponge:result_function", IngredientResultUtil.cacheResultFunction(this.id(), this.resultFunction));
        }
    }
}

