/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.advancements;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementNode;
import org.spongepowered.api.advancement.AdvancementTemplate;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.advancement.TreeLayoutElement;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={net.minecraft.advancements.AdvancementNode.class})
@Implements(value={@Interface(iface=AdvancementTree.class, prefix="tree$")})
public abstract class AdvancementNodeMixin_API
implements AdvancementTree {
    @Shadow
    @Final
    private AdvancementHolder holder;

    @Shadow
    public abstract net.minecraft.advancements.Advancement advancement();

    @Shadow
    public abstract Iterable<net.minecraft.advancements.AdvancementNode> shadow$children();

    @Override
    public Advancement rootAdvancement() {
        return (Advancement)this.holder.value();
    }

    @Override
    public ResourceKey key() {
        return (ResourceKey)this.holder.id();
    }

    @Intrinsic
    public Collection<AdvancementNode> tree$children() {
        HashSet<AdvancementNode> set = new HashSet<AdvancementNode>();
        for (net.minecraft.advancements.AdvancementNode child : this.shadow$children()) {
            set.add((AdvancementNode)child);
        }
        return set;
    }

    @Override
    public Optional<ResourceKey> backgroundPath() {
        Optional displayInfo = this.holder.value().display();
        return displayInfo.map(di -> (ResourceKey)di.getBackground());
    }

    @Override
    public Collection<TreeLayoutElement> layoutElements() {
        ImmutableSet.Builder elements = ImmutableSet.builder();
        this.impl$collectElements((net.minecraft.advancements.AdvancementNode)this, (ImmutableSet.Builder<TreeLayoutElement>)elements);
        return elements.build();
    }

    private void impl$collectElements(net.minecraft.advancements.AdvancementNode node, ImmutableSet.Builder<TreeLayoutElement> elements) {
        node.advancement().display().map(TreeLayoutElement.class::cast).ifPresent(arg_0 -> elements.add(arg_0));
        node.children().forEach(child -> this.impl$collectElements((net.minecraft.advancements.AdvancementNode)child, elements));
    }

    @Override
    public Optional<TreeLayoutElement> layoutElement(AdvancementTemplate advancement) {
        if (advancement.advancement().displayInfo().isEmpty()) {
            return Optional.empty();
        }
        return this.layoutElement(advancement.key());
    }

    @Override
    public Optional<TreeLayoutElement> layoutElement(ResourceKey advancementKey) {
        return this.impl$element((ResourceLocation)advancementKey);
    }

    private Optional<TreeLayoutElement> impl$element(ResourceLocation loc) {
        return this.impl$findElementInfo((net.minecraft.advancements.AdvancementNode)this, loc).map(TreeLayoutElement.class::cast);
    }

    private Optional<DisplayInfo> impl$findElementInfo(net.minecraft.advancements.AdvancementNode node, ResourceLocation key) {
        if (node.holder().id().equals((Object)key)) {
            return node.advancement().display();
        }
        for (net.minecraft.advancements.AdvancementNode child : node.children()) {
            Optional<DisplayInfo> info = this.impl$findElementInfo(child, key);
            if (!info.isPresent()) continue;
            return info;
        }
        return Optional.empty();
    }
}

