/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.advancements;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.AdvancementProgress;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.CriterionProgress;
import org.spongepowered.api.advancement.criteria.ScoreAdvancementCriterion;
import org.spongepowered.api.advancement.criteria.ScoreCriterionProgress;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.advancement.criterion.ImplementationBackedCriterionProgress;
import org.spongepowered.common.bridge.advancements.AdvancementProgressBridge;

@Mixin(value={AdvancementProgress.class})
public abstract class AdvancementProgressMixin_API
implements org.spongepowered.api.advancement.AdvancementProgress {
    @Override
    public Optional<Instant> get() {
        return this.get(this.advancement().criterion()).get().get();
    }

    @Override
    public Instant grant() {
        return this.get(this.advancement().criterion()).get().grant();
    }

    @Override
    public Optional<Instant> revoke() {
        return this.get(this.advancement().criterion()).get().revoke();
    }

    @Override
    public Advancement advancement() {
        return ((AdvancementProgressBridge)((Object)this)).bridge$getAdvancement();
    }

    @Override
    public Optional<CriterionProgress> get(AdvancementCriterion criterion) {
        Preconditions.checkNotNull((Object)criterion, (Object)"criterion");
        Map<String, ImplementationBackedCriterionProgress> map = ((AdvancementProgressBridge)((Object)this)).bridge$getProgressMap();
        Preconditions.checkState((map != null ? 1 : 0) != 0, (Object)"progressMap isn't initialized");
        return Optional.ofNullable((CriterionProgress)((Object)map.get(criterion.name())));
    }

    @Override
    public Optional<ScoreCriterionProgress> get(ScoreAdvancementCriterion criterion) {
        Preconditions.checkNotNull((Object)criterion);
        Map<String, ImplementationBackedCriterionProgress> map = ((AdvancementProgressBridge)((Object)this)).bridge$getProgressMap();
        Preconditions.checkState((map != null ? 1 : 0) != 0, (Object)"progressMap isn't initialized");
        return Optional.ofNullable((ScoreCriterionProgress)((Object)map.get(criterion.name())));
    }

    @Override
    public CriterionProgress require(AdvancementCriterion criterion) {
        Objects.requireNonNull(criterion, "criterion");
        return this.get(criterion).orElseThrow(() -> new IllegalStateException("The criterion " + criterion.name() + " isn't present on the advancement '" + this.advancement() + "'."));
    }

    @Override
    public ScoreCriterionProgress require(ScoreAdvancementCriterion criterion) {
        Objects.requireNonNull(criterion, "criterion");
        return this.get(criterion).orElseThrow(() -> new IllegalStateException("The score criterion " + criterion.name() + " isn't present on this advancement"));
    }
}

