/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.map;

import com.google.common.base.Preconditions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.map.decoration.MapDecoration;
import org.spongepowered.api.map.decoration.MapDecorationType;
import org.spongepowered.api.map.decoration.orientation.MapDecorationOrientation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.storage.MapDecorationBridge;
import org.spongepowered.common.map.decoration.SpongeMapDecorationType;
import org.spongepowered.common.map.decoration.orientation.SpongeMapDecorationOrientation;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MapUtil;
import org.spongepowered.math.vector.Vector2i;

@Mixin(value={net.minecraft.world.level.saveddata.maps.MapDecoration.class})
public abstract class MapDecorationMixin_API
implements MapDecoration {
    @Shadow
    @Final
    private MapDecoration.Type type;
    @Shadow
    private byte x;
    @Shadow
    private byte y;
    @Shadow
    private byte rot;

    @Shadow
    public abstract @Nullable Component shadow$name();

    @Override
    public MapDecorationType type() {
        return SpongeMapDecorationType.toSpongeType(this.type).orElseThrow(() -> new IllegalStateException("Tried to get MapDecoration type but it didn't exist in Sponge's registries! Have MC Decoration types been missed?"));
    }

    @Override
    public Vector2i position() {
        return new Vector2i((int)this.x, (int)this.y);
    }

    @Override
    public void setPosition(Vector2i position) {
        Preconditions.checkState((boolean)MapUtil.isInMapDecorationBounds(position.x()), (Object)"x position out of bounds");
        Preconditions.checkState((boolean)MapUtil.isInMapDecorationBounds(position.y()), (Object)"y position out of bounds");
        this.x = (byte)position.x();
        this.y = (byte)position.y();
        ((MapDecorationBridge)((Object)this)).bridge$markAllDirty();
    }

    @Override
    public void setRotation(MapDecorationOrientation dir) {
        this.rot = (byte)((SpongeMapDecorationOrientation)dir).getOrientationNumber();
        ((MapDecorationBridge)((Object)this)).bridge$markAllDirty();
    }

    @Override
    public MapDecorationOrientation rotation() {
        int rot = MapUtil.normalizeDecorationOrientation(this.rot);
        return MapUtil.getMapRotById(rot);
    }

    @Override
    public boolean isPersistent() {
        return ((MapDecorationBridge)((Object)this)).bridge$isPersistent();
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer data = DataContainer.createNew().set(Constants.Map.DECORATION_TYPE, this.type.getIcon()).set(Constants.Map.DECORATION_ID, ((MapDecorationBridge)((Object)this)).bridge$getKey()).set(Constants.Map.DECORATION_X, this.x).set(Constants.Map.DECORATION_Y, this.y).set(Constants.Map.DECORATION_ROTATION, (byte)MapUtil.normalizeDecorationOrientation(this.rot));
        if (this.shadow$name() != null) {
            data.set(Constants.Map.NAME, Component.Serializer.toJson((Component)this.shadow$name()));
        }
        return data;
    }
}

