/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.storage;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.level.storage.ServerLevelData;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.living.trader.WanderingTrader;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.WeatherType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ServerLevelData.class})
public interface ServerLevelDataMixin_API
extends ServerWorldProperties {
    @Shadow
    public int shadow$getWanderingTraderSpawnDelay();

    @Shadow
    public void shadow$setWanderingTraderSpawnDelay(int var1);

    @Shadow
    public int shadow$getWanderingTraderSpawnChance();

    @Shadow
    public void shadow$setWanderingTraderSpawnChance(int var1);

    @Shadow
    public void shadow$setWanderingTraderId(UUID var1);

    @Shadow
    public @Nullable UUID shadow$getWanderingTraderId();

    @Shadow
    public void shadow$setDayTime(long var1);

    @Override
    default public void setDayTime(MinecraftDayTime dayTime) {
        this.shadow$setDayTime(dayTime.asTicks().ticks());
    }

    @Override
    default public Ticks wanderingTraderSpawnDelay() {
        return Ticks.of(this.shadow$getWanderingTraderSpawnDelay());
    }

    @Override
    default public void setWanderingTraderSpawnDelay(Ticks delay) {
        this.shadow$setWanderingTraderSpawnDelay((int)delay.ticks());
    }

    @Override
    default public int wanderingTraderSpawnChance() {
        return this.shadow$getWanderingTraderSpawnChance();
    }

    @Override
    default public void setWanderingTraderSpawnChance(int chance) {
        this.shadow$setWanderingTraderSpawnChance(chance);
    }

    @Override
    default public void setWanderingTrader(@Nullable WanderingTrader trader) {
        this.shadow$setWanderingTraderId(trader == null ? null : trader.uniqueId());
    }

    @Override
    default public Optional<UUID> wanderTraderUniqueId() {
        return Optional.ofNullable(this.shadow$getWanderingTraderId());
    }

    @Override
    default public void setWeather(WeatherType type) {
        this.offer(Keys.WEATHER, Weather.of(Objects.requireNonNull(type, "type"), 120L));
    }

    @Override
    default public void setWeather(WeatherType type, Ticks ticks) {
        this.offer(Keys.WEATHER, Weather.of(Objects.requireNonNull(type, "type"), Objects.requireNonNull(ticks, "ticks")));
    }
}

