/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.concurrent.CompletionException;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientboundGameProfilePacket;
import net.minecraft.network.protocol.login.ClientboundLoginCompressionPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.network.ConnectionHolderBridge;
import org.spongepowered.common.network.channel.SpongeChannelManager;

@Mixin(value={ServerLoginPacketListenerImpl.class})
public abstract class ServerLoginPacketListenerImplMixin
implements ConnectionHolderBridge {
    @Shadow
    @Final
    Connection connection;
    @Shadow
    GameProfile authenticatedProfile;
    @Shadow
    @Final
    MinecraftServer server;
    @Shadow
    private ServerLoginPacketListenerImpl.State state;
    private boolean impl$accepted = false;

    @Shadow
    public abstract void shadow$disconnect(Component var1);

    @Override
    public Connection bridge$getConnection() {
        return this.connection;
    }

    @Inject(method={"verifyLoginAndFinishConnectionSetup"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;", ordinal=0)})
    private void impl$onHandleAcceptedLogin(GameProfile $$0, CallbackInfo ci) {
    }

    private void impl$disconnectClient(net.kyori.adventure.text.Component disconnectMessage) {
        Component reason = SpongeAdventure.asVanilla(disconnectMessage);
        this.shadow$disconnect(reason);
    }

    @Inject(method={"startClientVerification(Lcom/mojang/authlib/GameProfile;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/server/network/ServerLoginPacketListenerImpl;state:Lnet/minecraft/server/network/ServerLoginPacketListenerImpl$State;")}, cancellable=true)
    private void impl$handleAuthEventCancellation(CallbackInfo ci) {
        TextComponent disconnectMessage = net.kyori.adventure.text.Component.text((String)"You are not allowed to log in to this server.");
        Cause cause = Cause.of(EventContext.empty(), this);
        ServerSideConnectionEvent.Auth event = SpongeEventFactory.createServerSideConnectionEventAuth(cause, (net.kyori.adventure.text.Component)disconnectMessage, (net.kyori.adventure.text.Component)disconnectMessage, (ServerSideConnection)((Object)this));
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            this.impl$disconnectClient(event.message());
            ci.cancel();
        }
    }

    private static /* synthetic */ Object lambda$impl$onHandleAcceptedLogin$3(Throwable throwable) {
        if (throwable != null) {
            // empty if block
        }
        return null;
    }

    private /* synthetic */ Object lambda$impl$onHandleAcceptedLogin$2(Object ignored, Throwable throwable) {
        if (throwable != null) {
            if (throwable instanceof CompletionException) {
                throw (CompletionException)throwable;
            }
            throw new CompletionException(throwable);
        }
        this.state = ServerLoginPacketListenerImpl.State.ACCEPTED;
        if (this.server.getCompressionThreshold() >= 0 && !this.connection.isMemoryConnection()) {
            this.connection.send((Packet)new ClientboundLoginCompressionPacket(this.server.getCompressionThreshold()), PacketSendListener.thenRun(() -> this.connection.setupCompression(this.server.getCompressionThreshold(), true)));
        }
        this.connection.send((Packet)new ClientboundGameProfilePacket(this.authenticatedProfile));
        ServerPlayer var1 = this.server.getPlayerList().getPlayer(this.authenticatedProfile.getId());
        if (var1 == null) {
            ServerSideConnection connection = (ServerSideConnection)((Object)this);
            ((SpongeChannelManager)Sponge.channelManager()).sendChannelRegistrations(connection);
            try {
                Sponge.server().userManager().removeFromCache(this.authenticatedProfile.getId());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private /* synthetic */ Object lambda$impl$onHandleAcceptedLogin$0(Component componentOpt, Throwable throwable) {
        if (throwable != null) {
            ((ConnectionBridge)this.connection).bridge$setKickReason((Component)Component.literal((String)"An error occurred checking ban/whitelist status."));
            SpongeCommon.logger().error("An error occurred when checking the ban/whitelist status of {}.", (Object)this.authenticatedProfile.getId().toString());
            SpongeCommon.logger().error((Object)throwable);
        } else if (componentOpt != null) {
            ((ConnectionBridge)this.connection).bridge$setKickReason(componentOpt);
        }
        try {
            ((SpongeServer)SpongeCommon.server()).userManager().handlePlayerLogin(this.authenticatedProfile);
        }
        catch (IOException e) {
            throw new CompletionException(e);
        }
        return null;
    }
}

