/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.LightningEvent;
import org.spongepowered.api.event.entity.ExpireEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;

@Mixin(value={LightningBolt.class})
public abstract class LightningBoltMixin
extends EntityMixin {
    @Shadow
    private boolean visualOnly;
    @Shadow
    private int life;

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"))
    private List<net.minecraft.world.entity.Entity> impl$ThrowEventAndProcess(Level level, net.minecraft.world.entity.Entity thisEntity, AABB boundingBox, Predicate<net.minecraft.world.entity.Entity> predicate) {
        if (this.shadow$isRemoved() || this.shadow$level().isClientSide) {
            return Collections.emptyList();
        }
        List originalEntities = level.getEntities(thisEntity, boundingBox, predicate);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            LightningEvent.Strike strike = SpongeEventFactory.createLightningEventStrike(frame.currentCause(), originalEntities);
            Sponge.eventManager().post(strike);
            if (strike.isCancelled()) {
                List<net.minecraft.world.entity.Entity> list = Collections.emptyList();
                return list;
            }
        }
        return originalEntities;
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LightningBolt;discard()V")})
    private void impl$ThrowEventAndProcess(CallbackInfo ci) {
        if (this.shadow$isRemoved() || this.shadow$level().isClientSide || this.life >= 0) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            LightningEvent.Post strike = SpongeEventFactory.createLightningEventPost(frame.currentCause());
            Sponge.eventManager().post(strike);
            ExpireEntityEvent event = SpongeEventFactory.createExpireEntityEvent(frame.currentCause(), (Entity)((Object)this));
            Sponge.eventManager().post(event);
        }
    }
}

