/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.player;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.authlib.GameProfileHolderBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.entity.player.PlayerBridge;
import org.spongepowered.common.bridge.world.food.FoodDataBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.entity.LivingEntityMixin;
import org.spongepowered.common.util.ExperienceHolderUtil;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntityMixin
implements PlayerBridge,
GameProfileHolderBridge {
    @Shadow
    @Final
    protected static EntityDataAccessor<Byte> DATA_PLAYER_MODE_CUSTOMISATION;
    @Shadow
    public int experienceLevel;
    @Shadow
    public int totalExperience;
    @Shadow
    public float experienceProgress;
    @Shadow
    @Final
    private Abilities abilities;
    @Shadow
    @Final
    private Inventory inventory;
    @Shadow
    public AbstractContainerMenu containerMenu;
    @Shadow
    @Final
    public InventoryMenu inventoryMenu;
    @Shadow
    @Final
    private GameProfile gameProfile;
    private boolean impl$affectsSpawning = true;
    protected final boolean impl$isFake = ((PlatformEntityBridge)((Player)this)).bridge$isFakePlayer();

    @Shadow
    public abstract boolean shadow$isSpectator();

    @Shadow
    public abstract int shadow$getXpNeededForNextLevel();

    @Shadow
    public abstract @Nullable ItemEntity shadow$drop(ItemStack var1, boolean var2, boolean var3);

    @Shadow
    public abstract FoodData shadow$getFoodData();

    @Shadow
    public abstract Scoreboard shadow$getScoreboard();

    @Shadow
    public abstract boolean shadow$isCreative();

    @Shadow
    public abstract String shadow$getScoreboardName();

    @Shadow
    public abstract void shadow$awardStat(Stat<?> var1);

    @Shadow
    public abstract Component shadow$getDisplayName();

    @Shadow
    protected abstract void shadow$removeEntitiesOnShoulder();

    @Shadow
    public abstract void shadow$awardStat(ResourceLocation var1);

    @Shadow
    public abstract Abilities shadow$getAbilities();

    @Shadow
    public abstract Inventory shadow$getInventory();

    @Shadow
    public Either<Player.BedSleepingProblem, Unit> shadow$startSleepInBed(BlockPos param0) {
        return null;
    }

    @Shadow
    protected abstract void shadow$playShoulderEntityAmbientSound(CompoundTag var1);

    @Shadow
    public abstract Optional<GlobalPos> shadow$getLastDeathLocation();

    @Override
    public boolean bridge$affectsSpawning() {
        return this.impl$affectsSpawning && !this.shadow$isSpectator() && !this.bridge$vanishState().untargetable();
    }

    @Override
    public void bridge$setAffectsSpawning(boolean affectsSpawning) {
        this.impl$affectsSpawning = affectsSpawning;
    }

    @Override
    public GameProfile bridge$getGameProfile() {
        return this.gameProfile;
    }

    @Override
    public int bridge$getExperienceSinceLevel() {
        return this.totalExperience - ExperienceHolderUtil.xpAtLevel(this.experienceLevel);
    }

    @Override
    public void bridge$setExperienceSinceLevel(int experience) {
        this.totalExperience = ExperienceHolderUtil.xpAtLevel(this.experienceLevel) + experience;
        this.experienceProgress = (float)experience / (float)this.shadow$getXpNeededForNextLevel();
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;"))
    private List<Entity> impl$ignoreOtherEntitiesWhenUncollideable(Level level, Entity entity, AABB aabb) {
        if (this.bridge$vanishState().ignoresCollisions()) {
            return Collections.emptyList();
        }
        return level.getEntities(entity, aabb);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isSleeping()Z"))
    private boolean impl$postSleepingEvent(Player self) {
        if (self.isSleeping()) {
            if (!((LevelBridge)this.shadow$level()).bridge$isFake()) {
                CauseStackManager csm = PhaseTracker.getCauseStackManager();
                csm.pushCause(this);
                BlockPos bedLocation = this.shadow$getSleepingPos().get();
                BlockSnapshot snapshot = ((ServerWorld)this.shadow$level()).createSnapshot(bedLocation.getX(), bedLocation.getY(), bedLocation.getZ());
                SpongeCommon.post(SpongeEventFactory.createSleepingEventTick(csm.currentCause(), snapshot, (Living)((Object)this)));
                csm.popCause();
            }
            return true;
        }
        return false;
    }

    @Redirect(method={"getDisplayName"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getName()Lnet/minecraft/network/chat/Component;"))
    private Component impl$useCustomNameIfSet(Player playerEntity) {
        if (playerEntity instanceof net.minecraft.server.level.ServerPlayer) {
            if (playerEntity.hasCustomName()) {
                return playerEntity.getCustomName();
            }
            return playerEntity.getName();
        }
        return playerEntity.getName();
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;playShoulderEntityAmbientSound(Lnet/minecraft/nbt/CompoundTag;)V"))
    private void impl$ignoreShoulderSoundsWhileVanished(Player thisPlayer, CompoundTag tag) {
        if (!this.bridge$vanishState().createsSounds()) {
            return;
        }
        this.shadow$playShoulderEntityAmbientSound(tag);
    }

    @Redirect(method={"playSound(Lnet/minecraft/sounds/SoundEvent;FF)V", "giveExperienceLevels(I)V", "eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V"))
    private void impl$ignoreExperienceLevelSoundsWhileVanished(Level world, Player player, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch) {
        if (!this.bridge$vanishState().createsSounds()) {
            return;
        }
        this.shadow$level().playSound(player, x, y, z, sound, category, volume, pitch);
    }

    @Redirect(method={"canUseGameMasterBlocks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getPermissionLevel()I"))
    private int impl$checkPermissionForCommandBlock(Player playerEntity) {
        if (this instanceof Subject) {
            return ((Subject)((Object)this)).hasPermission("minecraft.commandblock") ? 2 : 0;
        }
        return this.shadow$getPermissionLevel();
    }

    @Redirect(method={"mayUseItemAt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hasAdventureModePlaceTagForBlock(Lnet/minecraft/core/Registry;Lnet/minecraft/world/level/block/state/pattern/BlockInWorld;)Z"))
    private boolean impl$callChangeBlockPre(ItemStack stack, Registry<Block> registry, BlockInWorld cachedBlockInfo) {
        if (!stack.hasAdventureModePlaceTagForBlock(registry, cachedBlockInfo)) {
            return false;
        }
        if (this.shadow$level() instanceof LevelBridge && !((LevelBridge)this.shadow$level()).bridge$isFake() && ShouldFire.CHANGE_BLOCK_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(stack));
                boolean bl = !SpongeCommonEventFactory.callChangeBlockEventPre((ServerLevelBridge)this.shadow$level(), cachedBlockInfo.getPos(), (Object)this).isCancelled();
                return bl;
            }
        }
        return true;
    }

    @Overwrite
    public @Nullable ItemEntity drop(ItemStack itemStackIn, boolean traceItem) {
        return this.shadow$drop(itemStackIn, false, traceItem);
    }

    @Inject(method={"getFireImmuneTicks"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$useCustomFireImmuneTicks(CallbackInfoReturnable<Integer> ci) {
        if (this.impl$hasCustomFireImmuneTicks) {
            ci.setReturnValue((Object)this.impl$fireImmuneTicks);
        }
    }

    @Inject(method={"interactOn"}, at={@At(value="HEAD")}, cancellable=true)
    protected void impl$onRightClickEntity(Entity entityToInteractOn, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
    }

    @Override
    public boolean impl$canCallIgniteEntityEvent() {
        return super.impl$canCallIgniteEntityEvent() && !this.shadow$isSpectator() && !this.shadow$isCreative();
    }

    @Inject(method={"canHarmPlayer"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onCanHarmPlayer(Player other, CallbackInfoReturnable<Boolean> cir) {
        if (!(other instanceof ServerPlayer)) {
            return;
        }
        Team otherTeam = other.getTeam();
        PlayerTeam thisTeam = ((Scoreboard)((ServerPlayerBridge)other).bridge$getScoreboard()).getPlayersTeam(this.shadow$getScoreboardName());
        cir.setReturnValue((Object)(otherTeam == null || !otherTeam.isAlliedTo((Team)thisTeam) || otherTeam.isAllowFriendlyFire() ? 1 : 0));
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$foodData(CallbackInfo ci) {
        ((FoodDataBridge)this.shadow$getFoodData()).bridge$setPlayer((Player)this);
    }
}

