/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.FallingBlock;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={net.minecraft.world.level.block.FallingBlock.class})
public abstract class FallingBlockMixin {
    @Redirect(method={"tick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Ljava/util/Random;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;getY()I"))
    public int impl$checkFallable(BlockPos pos, BlockState state, ServerLevel world, BlockPos samePos, Random random, CallbackInfo ci) {
        if (pos.getY() < 0) {
            return pos.getY();
        }
        if (!ShouldFire.CONSTRUCT_ENTITY_EVENT_PRE) {
            return pos.getY();
        }
        EntityType<FallingBlock> fallingBlock = EntityTypes.FALLING_BLOCK.get();
        ServerWorld spongeWorld = (ServerWorld)world;
        BlockSnapshot snapshot = spongeWorld.createSnapshot(pos.getX(), pos.getY(), pos.getZ());
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(snapshot);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.FALLING_BLOCK);
            ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(frame.currentCause(), ServerLocation.of((ServerWorld)world, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5), new Vector3d(0.0f, 0.0f, 0.0f), fallingBlock);
            if (SpongeCommon.post(event)) {
                int n = -1;
                return n;
            }
            int n = pos.getY();
            return n;
        }
    }
}

