/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.api;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.item.inventory.ArmorEquipable;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.comp.EquipmentInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={ArmorStand.class, Mob.class, Player.class})
public abstract class TraitMixin_ArmorEquipable_Inventory_API
implements ArmorEquipable {
    @Override
    public boolean canEquip(EquipmentType type) {
        return true;
    }

    @Override
    public boolean canEquip(EquipmentType type, @Nullable org.spongepowered.api.item.inventory.ItemStack equipment) {
        return true;
    }

    @Override
    public Optional<org.spongepowered.api.item.inventory.ItemStack> equipped(EquipmentType type) {
        InventoryAdapter inv = ((InventoryBridge)((Object)this)).bridge$getAdapter();
        EquipmentInventoryLens lens = this.impl$equipmentInventory(inv);
        Fabric fabric = inv.inventoryAdapter$getFabric();
        return Optional.of(ItemStackUtil.fromNative(lens.getSlotLens(type).getStack(fabric)));
    }

    @Override
    public boolean equip(EquipmentType type, @Nullable org.spongepowered.api.item.inventory.ItemStack equipment) {
        InventoryAdapter inv = ((InventoryBridge)((Object)this)).bridge$getAdapter();
        EquipmentInventoryLens lens = this.impl$equipmentInventory(inv);
        Fabric fabric = inv.inventoryAdapter$getFabric();
        return lens.getSlotLens(type).setStack(fabric, ItemStackUtil.toNative(equipment));
    }

    @Override
    public org.spongepowered.api.item.inventory.ItemStack itemInHand(HandType handType) {
        Preconditions.checkNotNull((Object)handType);
        ItemStack nmsItem = ((LivingEntity)this).getItemInHand((InteractionHand)handType);
        return ItemStackUtil.fromNative(nmsItem);
    }

    @Override
    public void setItemInHand(HandType handType, @Nullable org.spongepowered.api.item.inventory.ItemStack itemInHand) {
        Preconditions.checkNotNull((Object)handType);
        ((LivingEntity)this).setItemInHand((InteractionHand)handType, ItemStackUtil.toNative(itemInHand).copy());
    }

    @Override
    public org.spongepowered.api.item.inventory.ItemStack head() {
        return this.equipped(EquipmentTypes.HEAD).get();
    }

    @Override
    public void setHead(org.spongepowered.api.item.inventory.ItemStack head) {
        this.equip(EquipmentTypes.HEAD, head);
    }

    @Override
    public org.spongepowered.api.item.inventory.ItemStack chest() {
        return this.equipped(EquipmentTypes.CHEST).get();
    }

    @Override
    public void setChest(org.spongepowered.api.item.inventory.ItemStack chest) {
        this.equip(EquipmentTypes.CHEST, chest);
    }

    @Override
    public org.spongepowered.api.item.inventory.ItemStack legs() {
        return this.equipped(EquipmentTypes.LEGS).get();
    }

    @Override
    public void setLegs(org.spongepowered.api.item.inventory.ItemStack legs) {
        this.equip(EquipmentTypes.LEGS, legs);
    }

    @Override
    public org.spongepowered.api.item.inventory.ItemStack feet() {
        return this.equipped(EquipmentTypes.FEET).get();
    }

    @Override
    public void setFeet(org.spongepowered.api.item.inventory.ItemStack feet) {
        this.equip(EquipmentTypes.FEET, feet);
    }

    private EquipmentInventoryLens impl$equipmentInventory(InventoryAdapter adapter) {
        Lens rootLens = adapter.inventoryAdapter$getRootLens();
        if (rootLens instanceof EquipmentInventoryLens) {
            return (EquipmentInventoryLens)rootLens;
        }
        if (rootLens instanceof PlayerInventoryLens) {
            return ((PlayerInventoryLens)rootLens).getEquipmentLens();
        }
        throw new IllegalStateException("Unexpected lens for Equipable Inventory " + rootLens.getClass().getName());
    }
}

