/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.mixin.tracker.world.level.block.BlockMixin_Tracker;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;

@Mixin(value={LeavesBlock.class})
public abstract class LeavesBlockMixin_Tracker
extends BlockMixin_Tracker {
    @Shadow
    @Final
    public static BooleanProperty PERSISTENT;
    @Shadow
    @Final
    public static IntegerProperty DISTANCE;

    @Shadow
    protected abstract boolean shadow$decaying(net.minecraft.world.level.block.state.BlockState var1);

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z"))
    private boolean tracker$switchContextForDecay(ServerLevel serverWorld, BlockPos pos, net.minecraft.world.level.block.state.BlockState newState, int flags) {
        PhaseTracker instance = PhaseTracker.getInstance();
        try (@NonNull P context = ((PhaseContext)BlockPhase.State.BLOCK_DECAY.createPhaseContext(instance)).source(new SpongeLocatableBlockBuilder().world((ServerWorld)serverWorld).position(pos.getX(), pos.getY(), pos.getZ()).state((BlockState)newState).build());){
            if (context != null) {
                ((PhaseContext)context).buildAndSwitch();
            }
            boolean bl = serverWorld.setBlock(pos, newState, flags);
            return bl;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Overwrite
    public void randomTick(net.minecraft.world.level.block.state.BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (this.shadow$decaying(state)) {
            if (!((LevelBridge)worldIn).bridge$isFake()) {
                try (@NonNull P context = ((PhaseContext)BlockPhase.State.BLOCK_DECAY.createPhaseContext(PhaseTracker.SERVER)).source(new SpongeLocatableBlockBuilder().world((ServerWorld)worldIn).position(pos.getX(), pos.getY(), pos.getZ()).state((BlockState)state).build());){
                    ((PhaseContext)context).buildAndSwitch();
                    Block.dropResources((net.minecraft.world.level.block.state.BlockState)state, (Level)worldIn, (BlockPos)pos);
                    worldIn.removeBlock(pos, false);
                }
                return;
            }
            Block.dropResources((net.minecraft.world.level.block.state.BlockState)state, (Level)worldIn, (BlockPos)pos);
            worldIn.removeBlock(pos, false);
        }
    }
}

