/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel.raw;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.custom.CustomQueryPayload;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.ChannelException;
import org.spongepowered.api.network.channel.raw.RawDataChannel;
import org.spongepowered.api.network.channel.raw.handshake.RawHandshakeDataChannel;
import org.spongepowered.api.network.channel.raw.handshake.RawHandshakeDataRequestHandler;
import org.spongepowered.api.network.channel.raw.handshake.RawHandshakeDataRequestResponse;
import org.spongepowered.common.network.PacketUtil;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.SpongeChannel;
import org.spongepowered.common.network.channel.TransactionResult;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.network.channel.raw.SpongeRawDataChannel;

public class SpongeRawLoginDataChannel
implements RawHandshakeDataChannel {
    private final SpongeRawDataChannel parent;
    private final Map<Class<?>, RawHandshakeDataRequestHandler<?>> requestHandlers = new ConcurrentHashMap();

    public SpongeRawLoginDataChannel(SpongeRawDataChannel parent) {
        this.parent = parent;
    }

    private <C extends EngineConnection> RawHandshakeDataRequestHandler<? super C> getRequestHandler(C connection) {
        return SpongeChannel.getRequestHandler(connection, this.requestHandlers);
    }

    @Override
    public RawDataChannel parent() {
        return this.parent;
    }

    @Override
    public <C extends EngineConnection> void setRequestHandler(EngineConnectionSide<C> side, RawHandshakeDataRequestHandler<? super C> handler) {
        Objects.requireNonNull(side, "side");
        this.setRequestHandler(SpongeChannel.getConnectionClass(side), handler);
    }

    @Override
    public void setRequestHandler(RawHandshakeDataRequestHandler<EngineConnection> handler) {
        this.setRequestHandler(EngineConnection.class, handler);
    }

    @Override
    public <C extends EngineConnection> void setRequestHandler(Class<C> connectionType, RawHandshakeDataRequestHandler<? super C> handler) {
        Objects.requireNonNull(connectionType, "connectionType");
        Objects.requireNonNull(handler, "handler");
        this.requestHandlers.put(connectionType, handler);
    }

    <C extends EngineConnection> void handleRequestPayload(final C connection, ChannelBuf payload, final int transactionId) {
        RawHandshakeDataRequestHandler<C> handler = this.getRequestHandler(connection);
        RawHandshakeDataRequestResponse response = new RawHandshakeDataRequestResponse(){
            private boolean completed;

            private void checkCompleted() {
                if (this.completed) {
                    throw new ChannelException("The request response was already completed.");
                }
                this.completed = true;
            }

            @Override
            public void fail(ChannelException exception) {
                Objects.requireNonNull(exception, "exception");
                this.checkCompleted();
                PacketSender.sendTo(connection, PacketUtil.createLoginPayloadResponse(null, transactionId));
            }

            @Override
            public void success(Consumer<ChannelBuf> response) {
                ChannelBuf payload;
                Objects.requireNonNull(response, "response");
                this.checkCompleted();
                try {
                    payload = SpongeRawLoginDataChannel.this.parent.encodePayload(response);
                }
                catch (Throwable t) {
                    SpongeRawLoginDataChannel.this.parent.handleException(connection, new ChannelException("Failed to encode login data response", t), null);
                    PacketSender.sendTo(connection, PacketUtil.createLoginPayloadResponse(null, transactionId));
                    return;
                }
                PacketSender.sendTo(connection, PacketUtil.createLoginPayloadResponse(var1 -> var1.writeBytes((ByteBuf)((FriendlyByteBuf)payload)), transactionId));
            }
        };
        boolean success = false;
        if (handler != null) {
            try {
                handler.handleRequest(payload, connection, response);
                success = true;
            }
            catch (Throwable t) {
                this.parent.handleException(connection, new ChannelException("Failed to handle login data request", t), null);
            }
        }
        if (!success) {
            PacketSender.sendTo(connection, PacketUtil.createLoginPayloadResponse(null, transactionId));
        }
    }

    void handleTransactionResponse(EngineConnection connection, Object stored, TransactionResult result) {
        if (!(stored instanceof Consumer)) {
            return;
        }
        ((Consumer)stored).accept(result);
    }

    @Override
    public CompletableFuture<ChannelBuf> sendTo(EngineConnection connection, Consumer<ChannelBuf> payload) {
        ChannelBuf buf;
        ConnectionUtil.checkHandshakePhase(connection);
        CompletableFuture<ChannelBuf> future = new CompletableFuture<ChannelBuf>();
        try {
            buf = this.parent.encodePayload(payload);
        }
        catch (Throwable t) {
            this.parent.handleException(connection, t, future);
            return future;
        }
        TransactionStore transactionStore = ConnectionUtil.getTransactionStore(connection);
        int transactionId = transactionStore.nextId();
        Consumer<TransactionResult> resultConsumer = result -> {
            if (result.isSuccess()) {
                future.complete(result.getPayload());
            } else {
                this.parent.handleException(connection, result.getCause(), future);
            }
        };
        final ResourceKey id = this.parent.key();
        Packet<?> mcPacket = PacketUtil.createLoginPayloadRequest(new CustomQueryPayload(){

            public ResourceLocation id() {
                return (ResourceLocation)id;
            }

            public void write(FriendlyByteBuf var1) {
                var1.writeBytes((ByteBuf)((FriendlyByteBuf)buf));
            }
        }, transactionId);
        transactionStore.put(transactionId, this.parent, resultConsumer);
        PacketSender.sendTo(connection, mcPacket, throwable -> {
            if (throwable != null && transactionStore.remove(transactionId) != null) {
                future.completeExceptionally((Throwable)throwable);
            }
        });
        return future;
    }
}

