/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.raid;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import org.spongepowered.api.raid.RaidWave;
import org.spongepowered.common.accessor.world.entity.raid.RaidAccessor;

public final class SpongeRaidWave
implements RaidWave {
    private final Raid raid;
    private final int waveId;

    public SpongeRaidWave(Raid raid, int waveId) {
        this.raid = raid;
        this.waveId = waveId;
    }

    @Override
    public org.spongepowered.api.raid.Raid raid() {
        return (org.spongepowered.api.raid.Raid)this.raid;
    }

    @Override
    public boolean isBonus() {
        return !this.isFinal() && this.waveId >= ((RaidAccessor)this.raid).accessor$numGroups();
    }

    @Override
    public boolean isFinal() {
        return this.waveId == ((RaidAccessor)this.raid).accessor$numGroups();
    }

    @Override
    public Optional<org.spongepowered.api.entity.living.monster.raider.Raider> leader() {
        return Optional.ofNullable((org.spongepowered.api.entity.living.monster.raider.Raider)this.raid.getLeader(this.waveId));
    }

    @Override
    public boolean addRaider(org.spongepowered.api.entity.living.monster.raider.Raider raider, boolean addToRaidHealth) {
        Preconditions.checkNotNull((Object)raider, (Object)"Raider cannot be null.");
        return this.raid.addWaveMob(this.waveId, (Raider)raider, addToRaidHealth);
    }

    @Override
    public boolean removeRaider(org.spongepowered.api.entity.living.monster.raider.Raider raider) {
        Preconditions.checkNotNull((Object)raider, (Object)"Raider cannot be null.");
        if (raider.raidWave().isPresent() && this.equals(raider.raidWave().get().get())) {
            this.raid.removeFromRaid((Raider)raider, true);
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpongeRaidWave) {
            SpongeRaidWave other = (SpongeRaidWave)obj;
            if (this.waveId == other.waveId && this.raid.getLevel() == other.raid.getLevel() && this.raid.getId() == other.raid.getId()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("raid", (Object)this.raid).add("wave", this.waveId).toString();
    }
}

