/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.MappedRegistry;
import net.minecraft.resources.ResourceKey;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.common.registry.InitialRegistryData;
import org.spongepowered.common.registry.RegistryHolderLogic;
import org.spongepowered.common.registry.RegistryLoader;

public interface SpongeRegistryHolder
extends RegistryHolder {
    public RegistryHolderLogic registryHolder();

    default public void setRootMinecraftRegistry(net.minecraft.core.Registry<net.minecraft.core.Registry<?>> registry) {
        this.registryHolder().setRootMinecraftRegistry(registry);
    }

    default public <T> Registry<T> createRegistry(RegistryType<T> type, @Nullable InitialRegistryData<T> defaultValues, boolean isDynamic, @Nullable BiConsumer<ResourceKey<T>, T> callback) {
        return this.registryHolder().createRegistry(type, defaultValues, this.registryHolder().registrySupplier(isDynamic, callback));
    }

    default public <T> Registry<T> createRegistry(RegistryType<T> type, @Nullable Map<org.spongepowered.api.ResourceKey, T> defaultValues) {
        return this.createRegistry(type, defaultValues != null ? () -> defaultValues : null, false);
    }

    default public <T> Registry<T> createRegistry(RegistryType<T> type, @Nullable Supplier<Map<org.spongepowered.api.ResourceKey, T>> defaultValues) {
        return this.createRegistry(type, defaultValues, false);
    }

    default public <T> Registry<T> createRegistry(RegistryType<T> type, @Nullable Supplier<Map<org.spongepowered.api.ResourceKey, T>> defaultValues, boolean isDynamic) {
        return this.createRegistry(type, InitialRegistryData.noIds(defaultValues), isDynamic, null);
    }

    default public <T> Registry<T> createRegistry(RegistryType<T> type, RegistryLoader<T> loader) {
        return this.createRegistry(type, loader, false);
    }

    default public <T> Registry<T> createFrozenRegistry(RegistryType<T> type, RegistryLoader<T> loader) {
        Registry<T> registry = this.createRegistry(type, loader, false);
        if (registry instanceof MappedRegistry) {
            MappedRegistry toFreeze = (MappedRegistry)registry;
            toFreeze.freeze();
        }
        return registry;
    }

    default public <T> Registry<T> createRegistry(RegistryType<T> type, RegistryLoader<T> loader, boolean isDynamic) {
        return this.createRegistry(type, loader, isDynamic, null);
    }

    @Override
    default public Stream<Registry<?>> streamRegistries(org.spongepowered.api.ResourceKey root) {
        return this.registryHolder().streamRegistries(Objects.requireNonNull(root, "root"));
    }

    @Override
    default public <T> Optional<Registry<T>> findRegistry(RegistryType<T> type) {
        return this.registryHolder().findRegistry(Objects.requireNonNull(type, "type"));
    }

    @Override
    default public <T> Registry<T> registry(RegistryType<T> type) {
        return this.registryHolder().registry(Objects.requireNonNull(type, "type"));
    }
}

