/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.collect.Streams;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public final class NBTStreams {
    public static Stream<CompoundTag> toCompounds(Iterable<Tag> iterable) {
        return Streams.stream(iterable).filter(tag -> tag instanceof CompoundTag).map(tag -> (CompoundTag)tag);
    }

    public static Stream<String> toStrings(Iterable<Tag> iterable) {
        return Streams.stream(iterable).filter(tag -> tag instanceof StringTag).map(Tag::getAsString);
    }

    public static LongStream toLongs(Iterable<Tag> iterable) {
        return Streams.stream(iterable).filter(tag -> tag instanceof NumericTag).mapToLong(tag -> ((NumericTag)tag).getAsLong());
    }

    public static IntStream toInts(Iterable<Tag> iterable) {
        return Streams.stream(iterable).filter(tag -> tag instanceof NumericTag).mapToInt(tag -> ((NumericTag)tag).getAsInt());
    }

    private NBTStreams() {
    }
}

