/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config.noise;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.generation.config.SurfaceRule;
import org.spongepowered.api.world.generation.config.noise.Noise;

public final class SpongeSurfaceRulesFactory
implements SurfaceRule.Factory {
    @Override
    public SurfaceRule overworld() {
        return (SurfaceRule)SurfaceRuleData.overworld();
    }

    @Override
    public SurfaceRule overworldLike(boolean nearSurface, boolean bedrockRoof, boolean bedrockFloor) {
        return (SurfaceRule)SurfaceRuleData.overworldLike((boolean)nearSurface, (boolean)bedrockRoof, (boolean)bedrockFloor);
    }

    @Override
    public SurfaceRule nether() {
        return (SurfaceRule)SurfaceRuleData.nether();
    }

    @Override
    public SurfaceRule end() {
        return (SurfaceRule)SurfaceRuleData.end();
    }

    @Override
    public SurfaceRule firstOf(List<SurfaceRule> surfaceRules) {
        return (SurfaceRule)SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.stream().map(SurfaceRules.RuleSource.class::cast).toArray(SurfaceRules.RuleSource[]::new)));
    }

    @Override
    public SurfaceRule firstOf(SurfaceRule ... surfaceRules) {
        return this.firstOf(Arrays.asList(surfaceRules));
    }

    @Override
    public SurfaceRule badlands() {
        return (SurfaceRule)SurfaceRules.bandlands();
    }

    @Override
    public SurfaceRule block(BlockState blockState) {
        return (SurfaceRule)SurfaceRules.state((net.minecraft.world.level.block.state.BlockState)((net.minecraft.world.level.block.state.BlockState)blockState));
    }

    @Override
    public SurfaceRule test(List<SurfaceRule.Condition> conditions, SurfaceRule rule) {
        SurfaceRules.RuleSource mcRule = (SurfaceRules.RuleSource)rule;
        for (SurfaceRule.Condition condition : conditions) {
            mcRule = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)((SurfaceRules.ConditionSource)condition), (SurfaceRules.RuleSource)mcRule);
        }
        return (SurfaceRule)mcRule;
    }

    @Override
    public SurfaceRule test(SurfaceRule.Condition condition, SurfaceRule rule) {
        return this.test(List.of(condition), rule);
    }

    @Override
    public SurfaceRule.Condition liquidDepth(int offset, int depthMultiplier) {
        return (SurfaceRule.Condition)SurfaceRules.waterBlockCheck((int)offset, (int)depthMultiplier);
    }

    @Override
    public SurfaceRule.Condition liquidDepthFromSurface(int offset, int depthMultiplier) {
        return (SurfaceRule.Condition)SurfaceRules.waterStartCheck((int)offset, (int)depthMultiplier);
    }

    @Override
    public SurfaceRule.Condition biome(List<RegistryReference<Biome>> biomes) {
        Stream<ResourceKey> stream = biomes.stream().map(r -> ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)((ResourceLocation)r.location())));
        ResourceKey[] keys = (ResourceKey[])stream.toArray(ResourceKey[]::new);
        return (SurfaceRule.Condition)SurfaceRules.isBiome((ResourceKey[])keys);
    }

    @Override
    public SurfaceRule.Condition nearSurface() {
        return (SurfaceRule.Condition)SurfaceRules.abovePreliminarySurface();
    }

    @Override
    public SurfaceRule.Condition hole() {
        return (SurfaceRule.Condition)SurfaceRules.hole();
    }

    @Override
    public SurfaceRule.Condition verticalGradient(String randomSource, int fromY, int toY) {
        VerticalAnchor.Absolute trueAtAndBelowAnchor = new VerticalAnchor.Absolute(fromY);
        VerticalAnchor.Absolute falseAtAndAboveAnchor = new VerticalAnchor.Absolute(toY);
        return (SurfaceRule.Condition)SurfaceRules.verticalGradient((String)randomSource, (VerticalAnchor)trueAtAndBelowAnchor, (VerticalAnchor)falseAtAndAboveAnchor);
    }

    @Override
    public SurfaceRule.Condition verticalGradient(String randomSource, SurfaceRule.VerticalAnchor trueAtAndBelow, SurfaceRule.VerticalAnchor falseAtAndAbove) {
        return (SurfaceRule.Condition)SurfaceRules.verticalGradient((String)randomSource, (VerticalAnchor)((VerticalAnchor)trueAtAndBelow), (VerticalAnchor)((VerticalAnchor)falseAtAndAbove));
    }

    @Override
    public SurfaceRule.Condition steep() {
        return (SurfaceRule.Condition)SurfaceRules.steep();
    }

    @Override
    public SurfaceRule.Condition onFloor() {
        return (SurfaceRule.Condition)SurfaceRules.ON_FLOOR;
    }

    @Override
    public SurfaceRule.Condition underFloor(int depth) {
        return (SurfaceRule.Condition)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)depth, (CaveSurface)CaveSurface.FLOOR);
    }

    @Override
    public SurfaceRule.Condition floor(int offset, boolean useDepth, int secondaryDepth) {
        return (SurfaceRule.Condition)SurfaceRules.stoneDepthCheck((int)offset, (boolean)useDepth, (int)secondaryDepth, (CaveSurface)CaveSurface.FLOOR);
    }

    @Override
    public SurfaceRule.Condition onCeiling() {
        return (SurfaceRule.Condition)SurfaceRules.ON_CEILING;
    }

    @Override
    public SurfaceRule.Condition underCeiling(int depth) {
        return (SurfaceRule.Condition)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)depth, (CaveSurface)CaveSurface.CEILING);
    }

    @Override
    public SurfaceRule.Condition ceiling(int offset, boolean useDepth, int secondaryDepth) {
        return (SurfaceRule.Condition)SurfaceRules.stoneDepthCheck((int)offset, (boolean)useDepth, (int)secondaryDepth, (CaveSurface)CaveSurface.CEILING);
    }

    @Override
    public SurfaceRule.Condition not(SurfaceRule.Condition condition) {
        return (SurfaceRule.Condition)SurfaceRules.not((SurfaceRules.ConditionSource)((SurfaceRules.ConditionSource)condition));
    }

    @Override
    public SurfaceRule.Condition snowyTemperature() {
        return (SurfaceRule.Condition)SurfaceRules.temperature();
    }

    @Override
    public SurfaceRule.Condition blockAbove(SurfaceRule.VerticalAnchor anchor, int depthMultiplier) {
        return (SurfaceRule.Condition)SurfaceRules.yBlockCheck((VerticalAnchor)((VerticalAnchor)anchor), (int)depthMultiplier);
    }

    @Override
    public SurfaceRule.Condition surfaceAbove(SurfaceRule.VerticalAnchor anchor, int depthMultiplier) {
        return (SurfaceRule.Condition)SurfaceRules.yStartCheck((VerticalAnchor)((VerticalAnchor)anchor), (int)depthMultiplier);
    }

    @Override
    public SurfaceRule.Condition noiseThreshold(RegistryReference<Noise> noise, double min, double max) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.NOISE, (ResourceLocation)((ResourceLocation)noise.location()));
        return (SurfaceRule.Condition)SurfaceRules.noiseCondition((ResourceKey)key, (double)min, (double)max);
    }

    @Override
    public SurfaceRule.VerticalAnchor absolute(int y) {
        return (SurfaceRule.VerticalAnchor)VerticalAnchor.absolute((int)y);
    }

    @Override
    public SurfaceRule.VerticalAnchor belowTop(int blocks) {
        return (SurfaceRule.VerticalAnchor)VerticalAnchor.belowTop((int)blocks);
    }

    @Override
    public SurfaceRule.VerticalAnchor top() {
        return (SurfaceRule.VerticalAnchor)VerticalAnchor.top();
    }

    @Override
    public SurfaceRule.VerticalAnchor aboveBottom(int blocks) {
        return (SurfaceRule.VerticalAnchor)VerticalAnchor.aboveBottom((int)blocks);
    }

    @Override
    public SurfaceRule.VerticalAnchor bottom() {
        return (SurfaceRule.VerticalAnchor)VerticalAnchor.bottom();
    }
}

