/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Type;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.WorldTypes;
import org.spongepowered.api.world.biome.provider.BiomeProvider;
import org.spongepowered.api.world.generation.config.noise.NoiseGeneratorConfigs;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.WorldTemplate;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.fixer.SpongeDataCodec;
import org.spongepowered.common.data.holder.SpongeDataHolder;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.serialization.EnumCodec;
import org.spongepowered.common.serialization.MathCodecs;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeWorldTemplate
extends Record
implements WorldTemplate,
SpongeDataHolder {
    private final org.spongepowered.api.ResourceKey key;
    private final LevelStem levelStem;
    private final DataPack<WorldTemplate> pack;
    public static final Codec<LevelStem> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)DimensionType.CODEC.fieldOf("type").forGetter(LevelStem::type), (App)ChunkGenerator.CODEC.fieldOf("generator").forGetter(LevelStem::generator)).apply((Applicative)$$0, $$0.stable(LevelStem::new)));
    private static final Codec<SpongeDataSection> SPONGE_CODEC = RecordCodecBuilder.create(r -> r.group((App)SpongeAdventure.STRING_CODEC.optionalFieldOf("display_name").forGetter(v -> Optional.ofNullable(v.displayName)), (App)ResourceLocation.CODEC.optionalFieldOf("game_mode").forGetter(v -> Optional.ofNullable(v.gameMode).map(t -> new ResourceLocation("sponge", t.getName()))), (App)ResourceLocation.CODEC.optionalFieldOf("difficulty").forGetter(v -> Optional.ofNullable(v.difficulty).map(t -> new ResourceLocation("sponge", t.getKey()))), (App)EnumCodec.create(SerializationBehavior.class).optionalFieldOf("serialization_behavior").forGetter(v -> Optional.ofNullable(v.serializationBehavior)), (App)Codec.INT.optionalFieldOf("view_distance").forGetter(v -> Optional.ofNullable(v.viewDistance)), (App)MathCodecs.VECTOR_3i.optionalFieldOf("spawn_position").forGetter(v -> Optional.ofNullable(v.spawnPosition)), (App)Codec.BOOL.optionalFieldOf("load_on_startup").forGetter(v -> Optional.ofNullable(v.loadOnStartup)), (App)Codec.BOOL.optionalFieldOf("performs_spawn_logic").forGetter(v -> Optional.ofNullable(v.performsSpawnLogic)), (App)Codec.BOOL.optionalFieldOf("hardcore").forGetter(v -> Optional.ofNullable(v.hardcore)), (App)Codec.BOOL.optionalFieldOf("commands").forGetter(v -> Optional.ofNullable(v.commands)), (App)Codec.BOOL.optionalFieldOf("pvp").forGetter(v -> Optional.ofNullable(v.pvp)), (App)Codec.LONG.optionalFieldOf("seed").forGetter(v -> Optional.ofNullable(v.seed))).apply((Applicative)r, (f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12) -> new SpongeDataSection(f1.orElse(null), f2.map(l -> GameType.byName((String)l.getPath())).orElse(null), f3.map(l -> Difficulty.byName((String)l.getPath())).orElse(null), f4.orElse(null), f5.orElse(null), f6.orElse(null), f7.orElse(null), f8.orElse(null), f9.orElse(null), f10.orElse(null), f11.orElse(null), f12.orElse(null))));
    public static final Codec<LevelStem> DIRECT_CODEC = new MapCodec.MapCodecCodec(new SpongeDataCodec<LevelStem, SpongeDataSection>(LevelStem.CODEC, SPONGE_CODEC, (type, data) -> ((LevelStemBridge)type).bridge$decorateData((SpongeDataSection)data), type -> ((LevelStemBridge)type).bridge$createData()));

    public SpongeWorldTemplate(org.spongepowered.api.ResourceKey key, LevelStem levelStem, DataPack<WorldTemplate> pack) {
        this.key = key;
        this.levelStem = levelStem;
        this.pack = pack;
    }

    @Override
    public List<DataHolder> impl$delegateDataHolder() {
        return List.of((DataHolder)this.levelStem, this);
    }

    public static LevelStem decodeStem(JsonElement pack, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        SpongeWorldTemplate.fixDimensionDatapack(pack);
        return (LevelStem)LevelStem.CODEC.parse((DynamicOps)ops, (Object)pack).getOrThrow(false, e -> {});
    }

    public static WorldTemplate decode(DataPack<WorldTemplate> pack, org.spongepowered.api.ResourceKey key, JsonElement packEntry, RegistryAccess registryAccess) {
        LevelStem stem = SpongeWorldTemplate.decodeStem(packEntry, registryAccess);
        return new SpongeWorldTemplate(key, stem, pack);
    }

    private static void fixDimensionDatapack(JsonElement element) {
        try {
            JsonObject biomeSource = element.getAsJsonObject().getAsJsonObject("generator").getAsJsonObject("biome_source");
            if ("minecraft:vanilla_layered".equals(biomeSource.get("type").getAsString())) {
                biomeSource.addProperty("type", "minecraft:multi_noise");
                biomeSource.addProperty("preset", "minecraft:overworld");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongeWorldTemplate.serialize(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            DataContainer container = DataFormats.JSON.get().read(serialized.toString());
            container.set(Queries.CONTENT_VERSION, this.contentVersion());
            return container;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized LevelStem:\n" + serialized, e);
        }
    }

    public static JsonElement serialize(WorldTemplate s, RegistryAccess registryAccess) {
        if (s instanceof SpongeWorldTemplate) {
            SpongeWorldTemplate t = (SpongeWorldTemplate)s;
            RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
            return (JsonElement)DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)t.levelStem).getOrThrow(false, e -> {});
        }
        throw new IllegalArgumentException("WorldTemplate is not a SpongeWorldTemplate");
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeWorldTemplate.class, "key;levelStem;pack", "key", "levelStem", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeWorldTemplate.class, "key;levelStem;pack", "key", "levelStem", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeWorldTemplate.class, "key;levelStem;pack", "key", "levelStem", "pack"}, this, o);
    }

    @Override
    public org.spongepowered.api.ResourceKey key() {
        return this.key;
    }

    public LevelStem levelStem() {
        return this.levelStem;
    }

    @Override
    public DataPack<WorldTemplate> pack() {
        return this.pack;
    }

    public record SpongeDataSection(@Nullable Component displayName, @Nullable GameType gameMode, @Nullable Difficulty difficulty, @Nullable SerializationBehavior serializationBehavior, @Nullable Integer viewDistance, @Nullable Vector3i spawnPosition, @Nullable Boolean loadOnStartup, @Nullable Boolean performsSpawnLogic, @Nullable Boolean hardcore, @Nullable Boolean commands, @Nullable Boolean pvp, @Nullable Long seed) {
    }

    public static final class FactoryImpl
    implements WorldTemplate.Factory {
        @Override
        public WorldTemplate overworld() {
            return (WorldTemplate)((WorldTemplate.Builder)new BuilderImpl().reset().key(org.spongepowered.api.ResourceKey.minecraft("overworld"))).add(Keys.WORLD_TYPE, WorldTypes.OVERWORLD.get()).add(Keys.CHUNK_GENERATOR, org.spongepowered.api.world.generation.ChunkGenerator.overworld()).add(Keys.PERFORM_SPAWN_LOGIC, true).build();
        }

        @Override
        public WorldTemplate overworldCaves() {
            return (WorldTemplate)((WorldTemplate.Builder)new BuilderImpl().reset().key(org.spongepowered.api.ResourceKey.minecraft("overworld_caves"))).add(Keys.WORLD_TYPE, WorldTypes.OVERWORLD.get()).add(Keys.CHUNK_GENERATOR, org.spongepowered.api.world.generation.ChunkGenerator.noise(BiomeProvider.overworld(), NoiseGeneratorConfigs.CAVES.get())).add(Keys.PERFORM_SPAWN_LOGIC, true).build();
        }

        @Override
        public WorldTemplate theNether() {
            return (WorldTemplate)((WorldTemplate.Builder)new BuilderImpl().reset().key(org.spongepowered.api.ResourceKey.minecraft("the_nether"))).add(Keys.WORLD_TYPE, WorldTypes.THE_NETHER.get()).add(Keys.CHUNK_GENERATOR, org.spongepowered.api.world.generation.ChunkGenerator.theNether()).build();
        }

        @Override
        public WorldTemplate theEnd() {
            return (WorldTemplate)((WorldTemplate.Builder)new BuilderImpl().reset().key(org.spongepowered.api.ResourceKey.minecraft("the_end"))).add(Keys.WORLD_TYPE, WorldTypes.THE_END.get()).add(Keys.CHUNK_GENERATOR, org.spongepowered.api.world.generation.ChunkGenerator.theEnd()).build();
        }
    }

    public static final class BuilderImpl
    extends AbstractResourceKeyedBuilder<WorldTemplate, WorldTemplate.Builder>
    implements WorldTemplate.Builder {
        private static DataProviderLookup PROVIDER_LOOKUP = SpongeDataManager.getProviderRegistry().getProviderLookup(LevelStem.class);
        private DataManipulator.Mutable data = DataManipulator.mutableOf();
        private DataPack<WorldTemplate> pack = DataPacks.WORLD;

        @Override
        public <V> WorldTemplate.Builder add(Key<? extends Value<V>> key, V value) {
            if (!PROVIDER_LOOKUP.getProvider(key).isSupported((Type)((Object)LevelStem.class))) {
                throw new IllegalArgumentException(key + " is not supported for world templates");
            }
            this.data.set(key, value);
            return this;
        }

        @Override
        public WorldTemplate.Builder reset() {
            super.reset();
            this.data = DataManipulator.mutableOf();
            this.data.set(Keys.WORLD_TYPE, WorldTypes.OVERWORLD.get());
            this.data.set(Keys.CHUNK_GENERATOR, org.spongepowered.api.world.generation.ChunkGenerator.overworld());
            this.pack = DataPacks.WORLD;
            return this;
        }

        @Override
        public WorldTemplate.Builder from(WorldTemplate template) {
            this.key = Objects.requireNonNull(template, "template").key();
            this.data = DataManipulator.mutableOf(template.getValues());
            this.pack = template.pack();
            return this;
        }

        @Override
        public WorldTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(pack));
            LevelStem levelStem = SpongeWorldTemplate.decodeStem(json, (RegistryAccess)SpongeCommon.server().registryAccess());
            return this.from(levelStem);
        }

        @Override
        public WorldTemplate.Builder from(ServerWorld world) {
            this.from(world.properties());
            this.data.set(Keys.CHUNK_GENERATOR, world.generator());
            return this;
        }

        @Override
        public WorldTemplate.Builder pack(DataPack<WorldTemplate> pack) {
            this.pack = pack;
            return this;
        }

        @Override
        public WorldTemplate.Builder from(ServerWorldProperties properties) {
            PrimaryLevelDataBridge bridge = (PrimaryLevelDataBridge)((Object)properties);
            this.key = properties.key();
            properties.displayName().ifPresent(name -> this.data.set(Keys.DISPLAY_NAME, name));
            this.data.set(Keys.WORLD_TYPE, properties.worldType());
            if (bridge.bridge$customGameType()) {
                this.data.set(Keys.GAME_MODE, properties.gameMode());
            }
            if (bridge.bridge$customDifficulty()) {
                this.data.set(Keys.WORLD_DIFFICULTY, properties.difficulty());
            }
            bridge.bridge$serializationBehavior().ifPresent(s -> this.data.set(Keys.SERIALIZATION_BEHAVIOR, s));
            bridge.bridge$viewDistance().ifPresent(v -> this.data.set(Keys.VIEW_DISTANCE, v));
            if (bridge.bridge$customSpawnPosition()) {
                this.data.set(Keys.SPAWN_POSITION, properties.spawnPosition());
            }
            this.data.set(Keys.IS_LOAD_ON_STARTUP, Boolean.valueOf(properties.loadOnStartup()));
            this.data.set(Keys.PERFORM_SPAWN_LOGIC, Boolean.valueOf(properties.performsSpawnLogic()));
            this.data.set(Keys.HARDCORE, Boolean.valueOf(properties.hardcore()));
            this.data.set(Keys.COMMANDS, Boolean.valueOf(properties.commands()));
            this.data.set(Keys.PVP, Boolean.valueOf(properties.pvp()));
            return this;
        }

        @Override
        private WorldTemplate.Builder from(LevelStem levelStem) {
            this.data.set(((DataHolder)levelStem).getValues());
            return this;
        }

        @Override
        protected WorldTemplate build0() {
            org.spongepowered.api.world.generation.ChunkGenerator chunkGenerator = this.data.require(Keys.CHUNK_GENERATOR);
            Holder<DimensionType> dimensionType = BuilderImpl.dimensionTypeHolder(this.data.require(Keys.WORLD_TYPE));
            LevelStem levelStem = new LevelStem(dimensionType, (ChunkGenerator)chunkGenerator);
            ((LevelStemBridge)levelStem).bridge$decorateData(this.data);
            return new SpongeWorldTemplate(this.key, levelStem, this.pack);
        }

        private static @NonNull Holder<DimensionType> dimensionTypeHolder(WorldType worldType) {
            Registry dimensionTypeRegistry = SpongeCommon.server().registryAccess().registryOrThrow(Registries.DIMENSION_TYPE);
            ResourceLocation key = dimensionTypeRegistry.getKey((Object)((DimensionType)worldType));
            if (key == null) {
                return Holder.direct((Object)((DimensionType)worldType));
            }
            return dimensionTypeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)key));
        }
    }
}

