/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.biome;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.Biomes;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.AbstractBiomeBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class ByteArrayMutableBiomeBuffer
extends AbstractBiomeBuffer
implements BiomeVolume.Mutable {
    private final byte[] biomes;
    private final Palette.Mutable<Biome, Biome> palette;

    public ByteArrayMutableBiomeBuffer(Palette<Biome, Biome> palette, Vector3i start, Vector3i size) {
        this(palette, new byte[size.x() * size.y() * size.z()], start, size);
    }

    public ByteArrayMutableBiomeBuffer(Palette<Biome, Biome> palette, byte[] biomes, Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = biomes;
        this.palette = palette.asMutable(Sponge.game());
    }

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        this.checkRange(x, y, z);
        this.biomes[this.getIndex((int)x, (int)y, (int)z)] = (byte)this.palette.orAssign(biome);
        return true;
    }

    @Override
    public Biome biome(int x, int y, int z) {
        this.checkRange(x, y, z);
        byte biomeId = this.biomes[this.getIndex(x, y, z)];
        return this.palette.get(biomeId & 0xFF, Sponge.server()).orElseGet(() -> Biomes.OCEAN.get(Sponge.server()));
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ByteArrayMutableBiomeBuffer that = (ByteArrayMutableBiomeBuffer)o;
        return Arrays.equals(this.biomes, that.biomes) && this.palette.equals(that.palette);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.palette);
        result = 31 * result + Arrays.hashCode(this.biomes);
        return result;
    }

    @Override
    public VolumeStream<BiomeVolume.Mutable, Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.min();
        Vector3i blockMax = this.max();
        VolumeStreamUtils.validateStreamArgs(min, max, blockMin, blockMax, options);
        byte[] biomes = options.carbonCopy() ? Arrays.copyOf(this.biomes, this.biomes.length) : this.biomes;
        Stream stateStream = IntStream.rangeClosed(min.x(), max.x()).mapToObj(x -> IntStream.rangeClosed(min.z(), max.z()).mapToObj(z -> IntStream.rangeClosed(min.y(), max.y()).mapToObj(y -> VolumeElement.of(this, () -> {
            byte biomeId = biomes[this.getIndex(x, y, z)];
            return this.palette.get(biomeId & 0xFF, Sponge.server()).orElseGet(() -> (Biome)Sponge.server().registry(RegistryTypes.BIOME).value(Biomes.OCEAN));
        }, new Vector3d((float)x, (float)y, (float)z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<BiomeVolume.Mutable, Biome>(stateStream, () -> this);
    }

    public Palette.Mutable<Biome, Biome> getPalette() {
        return this.palette;
    }
}

