/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.transformers.modlauncher;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.fabricmc.accesswidener.AccessWidener;
import net.fabricmc.accesswidener.AccessWidenerClassVisitor;
import net.fabricmc.accesswidener.AccessWidenerReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class AccessWidenerTransformationService
implements ITransformationService {
    public static final String NAME = "access_widener";
    public static final String ACCESS_WIDENER_EXTENSION = "accesswidener";
    public static final Supplier<TypesafeMap.Key<AccessWidenerTransformationService>> INSTANCE = IEnvironment.buildKey((String)"sponge:aw", AccessWidenerTransformationService.class);
    static final Logger LOGGER = LogManager.getLogger();
    private final AccessWidener widener = new AccessWidener();
    private final AccessWidenerReader reader = new AccessWidenerReader(this.widener);
    private @MonotonicNonNull OptionSpec<String> configSpec;

    public @NonNull String name() {
        return NAME;
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
        env.computePropertyIfAbsent(INSTANCE.get(), k -> this);
    }

    public void arguments(BiFunction<String, String, OptionSpecBuilder> argumentBuilder) {
        this.configSpec = argumentBuilder.apply("config", "An AW file to apply at runtime").withOptionalArg().withValuesSeparatedBy(",");
    }

    public void argumentValues(ITransformationService.OptionResult option) {
        if (this.configSpec != null) {
            for (String value : option.values(this.configSpec)) {
                URL resource = AccessWidenerTransformationService.class.getClassLoader().getResource(value);
                if (resource == null) {
                    throw new IllegalStateException("Could not locate AW resource specified on command line " + value);
                }
                this.offerResource(resource, "command-line");
            }
        }
        super.argumentValues(option);
    }

    public void initialize(IEnvironment environment) {
    }

    public void beginScanning(IEnvironment environment) {
    }

    public @NonNull List<ITransformer> transformers() {
        return Collections.singletonList(new AWTransformer(this.widener));
    }

    public void offerResource(URL resource, String name) {
        if (resource.getFile().endsWith(ACCESS_WIDENER_EXTENSION)) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));){
                LOGGER.debug("Reading access widener {} from {}", (Object)name, (Object)resource);
                this.reader.read(reader);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to load access widener {} from {}", (Object)name, (Object)resource, (Object)ex);
            }
        } else {
            LOGGER.warn("Offered access widener {} from {} that does not end with expected extension '{}'", (Object)name, (Object)resource, (Object)ACCESS_WIDENER_EXTENSION);
        }
    }

    static class AWTransformer
    implements ITransformer<ClassNode> {
        private final AccessWidener widener;

        AWTransformer(AccessWidener widener) {
            this.widener = widener;
        }

        public @NonNull ClassNode transform(ClassNode input, ITransformerVotingContext context) {
            LOGGER.debug("Transforming {}", (Object)context.getClassName());
            ClassNode output = new ClassNode(589824);
            ClassVisitor visitor = AccessWidenerClassVisitor.createClassVisitor(589824, output, this.widener);
            input.accept(visitor);
            return output;
        }

        public @NonNull TransformerVoteResult castVote(ITransformerVotingContext context) {
            TransformerVoteResult result = context.getReason().equals("classloading") ? TransformerVoteResult.YES : TransformerVoteResult.NO;
            LOGGER.debug("Voting on {} with reason {}, result: {}", (Object)context.getClassName(), (Object)context.getReason(), (Object)result);
            return result;
        }

        public @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
        ITransformer.Target> targets() {
            Set<String> classNames = this.widener.getTargets();
            HashSet<ITransformer.Target> targets = new HashSet<ITransformer.Target>(classNames.size());
            for (String clazz : classNames) {
                targets.add(ITransformer.Target.targetClass((String)clazz.replace('.', '/')));
            }
            return targets;
        }
    }
}

