/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public abstract class ScrollPanel
extends AbstractContainerEventHandler
implements Renderable {
    private final Minecraft client;
    protected final int width;
    protected final int height;
    protected final int top;
    protected final int bottom;
    protected final int right;
    protected final int left;
    private boolean scrolling;
    protected float scrollDistance;
    protected final int border = 4;
    private final int barWidth = 6;
    private final int barLeft;

    public ScrollPanel(Minecraft client, int width, int height, int top, int left) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
        this.bottom = height + this.top;
        this.right = width + this.left;
        this.barLeft = this.left + this.width - this.barWidth;
    }

    protected abstract int getContentHeight();

    protected void drawBackground() {
    }

    protected abstract void drawPanel(GuiGraphics var1, int var2, int var3, Tesselator var4, int var5, int var6);

    protected boolean clickPanel(double mouseX, double mouseY, int button) {
        return false;
    }

    private int getMaxScroll() {
        return this.getContentHeight() - (this.height - this.border);
    }

    private void applyScrollLimits() {
        int max = Math.max(0, this.getMaxScroll());
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        if (this.scrollDistance > (float)max) {
            this.scrollDistance = max;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll, double $$3) {
        if (scroll != 0.0) {
            this.scrollDistance = (float)((double)this.scrollDistance + -scroll * (double)this.getScrollAmount());
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    protected int getScrollAmount() {
        return 20;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.left && mouseX <= (double)(this.left + this.width) && mouseY >= (double)this.top && mouseY <= (double)this.bottom;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        boolean bl = this.scrolling = button == 0 && mouseX >= (double)this.barLeft && mouseX < (double)(this.barLeft + this.barWidth);
        if (this.scrolling) {
            return true;
        }
        int mouseListY = (int)mouseY - this.top - this.getContentHeight() + (int)this.scrollDistance - this.border;
        if (mouseX >= (double)this.left && mouseX <= (double)this.right && mouseListY < 0) {
            return this.clickPanel(mouseX - (double)this.left, mouseY - (double)this.top + (double)((int)this.scrollDistance) - (double)this.border, button);
        }
        return false;
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_)) {
            return true;
        }
        boolean ret = this.scrolling;
        this.scrolling = false;
        return ret;
    }

    private int getBarHeight() {
        int barHeight = this.height * this.height / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.height - this.border * 2) {
            barHeight = this.height - this.border * 2;
        }
        return barHeight;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            int maxScroll = this.height - this.getBarHeight();
            double moved = deltaY / (double)maxScroll;
            this.scrollDistance = (float)((double)this.scrollDistance + (double)this.getMaxScroll() * moved);
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    public void render(GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
        this.drawBackground();
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder worldr = tess.getBuilder();
        double scale = this.client.getWindow().getGuiScale();
        RenderSystem.enableScissor((int)((int)((double)this.left * scale)), (int)((int)((double)this.client.getWindow().getHeight() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Screen.BACKGROUND_LOCATION);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float texScale = 32.0f;
        worldr.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        worldr.vertex((double)this.left, (double)this.bottom, 0.0).uv((float)this.left / 32.0f, (float)(this.bottom + (int)this.scrollDistance) / 32.0f).color(32, 32, 32, 255).endVertex();
        worldr.vertex((double)this.right, (double)this.bottom, 0.0).uv((float)this.right / 32.0f, (float)(this.bottom + (int)this.scrollDistance) / 32.0f).color(32, 32, 32, 255).endVertex();
        worldr.vertex((double)this.right, (double)this.top, 0.0).uv((float)this.right / 32.0f, (float)(this.top + (int)this.scrollDistance) / 32.0f).color(32, 32, 32, 255).endVertex();
        worldr.vertex((double)this.left, (double)this.top, 0.0).uv((float)this.left / 32.0f, (float)(this.top + (int)this.scrollDistance) / 32.0f).color(32, 32, 32, 255).endVertex();
        tess.end();
        int baseY = this.top + this.border - (int)this.scrollDistance;
        this.drawPanel(stack, this.right, baseY, tess, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        int extraHeight = this.getContentHeight() + this.border - this.height;
        if (extraHeight > 0) {
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.height - barHeight) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            worldr.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            worldr.vertex((double)this.barLeft, (double)this.bottom, 0.0).color(0, 0, 0, 255).endVertex();
            worldr.vertex((double)(this.barLeft + this.barWidth), (double)this.bottom, 0.0).color(0, 0, 0, 255).endVertex();
            worldr.vertex((double)(this.barLeft + this.barWidth), (double)this.top, 0.0).color(0, 0, 0, 255).endVertex();
            worldr.vertex((double)this.barLeft, (double)this.top, 0.0).color(0, 0, 0, 255).endVertex();
            tess.end();
            worldr.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            worldr.vertex((double)this.barLeft, (double)(barTop + barHeight), 0.0).color(128, 128, 128, 255).endVertex();
            worldr.vertex((double)(this.barLeft + this.barWidth), (double)(barTop + barHeight), 0.0).color(128, 128, 128, 255).endVertex();
            worldr.vertex((double)(this.barLeft + this.barWidth), (double)barTop, 0.0).color(128, 128, 128, 255).endVertex();
            worldr.vertex((double)this.barLeft, (double)barTop, 0.0).color(128, 128, 128, 255).endVertex();
            tess.end();
            worldr.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            worldr.vertex((double)this.barLeft, (double)(barTop + barHeight - 1), 0.0).color(192, 192, 192, 255).endVertex();
            worldr.vertex((double)(this.barLeft + this.barWidth - 1), (double)(barTop + barHeight - 1), 0.0).color(192, 192, 192, 255).endVertex();
            worldr.vertex((double)(this.barLeft + this.barWidth - 1), (double)barTop, 0.0).color(192, 192, 192, 255).endVertex();
            worldr.vertex((double)this.barLeft, (double)barTop, 0.0).color(192, 192, 192, 255).endVertex();
            tess.end();
        }
        RenderSystem.disableBlend();
        RenderSystem.disableScissor();
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }
}

