/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.server.network;

import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.query.QueryTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.vanilla.mixin.core.server.network.ServerCommonPacketListenerImplMixin_Vanilla;

@Mixin(value={ServerGamePacketListenerImpl.class}, priority=999)
public abstract class ServerGamePacketListenerImplMixin_Vanilla
extends ServerCommonPacketListenerImplMixin_Vanilla
implements ServerGamePacketListener {
    @Shadow
    public ServerPlayer player;

    @Redirect(method={"lambda$handlePlaceRecipe$11"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/RecipeBookMenu;handlePlacement(ZLnet/minecraft/world/item/crafting/RecipeHolder;Lnet/minecraft/server/level/ServerPlayer;)V"))
    private void vanilla$onPlaceRecipe(RecipeBookMenu recipeBookMenu, boolean shift, RecipeHolder<?> recipe, ServerPlayer player) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        Inventory craftInv = ((Inventory)player.containerMenu).query(QueryTypes.INVENTORY_TYPE.get().of(CraftingInventory.class));
        if (!(craftInv instanceof CraftingInventory)) {
            recipeBookMenu.handlePlacement(shift, recipe, player);
            SpongeCommon.logger().warn("Detected crafting without a InventoryCrafting!? Crafting Event will not fire.");
            return;
        }
        try (EffectTransactor ignored = transactor.logPlaceRecipe(shift, recipe, player, (CraftingInventory)craftInv);){
            recipeBookMenu.handlePlacement(shift, recipe, player);
            player.containerMenu.broadcastChanges();
        }
    }

    @Redirect(method={"handleInteract"}, at=@At(value="FIELD", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;MAX_INTERACTION_DISTANCE:D"))
    private double vanilla$getPlatformReach(ServerboundInteractPacket packet) {
        return PlatformHooks.INSTANCE.getGeneralHooks().getEntityReachDistanceSq(this.player, packet.getTarget(this.player.serverLevel()));
    }
}

