/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.tinylog.Level;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.BundleContextProvider;
import org.tinylog.provider.ContextProvider;
import org.tinylog.provider.LoggingProvider;

public final class BundleLoggingProvider
implements LoggingProvider {
    private final LoggingProvider[] loggingProviders;
    private final ContextProvider contextProvider;

    BundleLoggingProvider(Collection<LoggingProvider> providers) {
        this.loggingProviders = providers.toArray(new LoggingProvider[0]);
        this.contextProvider = BundleLoggingProvider.createContextProvider(providers);
    }

    @Override
    public ContextProvider getContextProvider() {
        return this.contextProvider;
    }

    @Override
    public Level getMinimumLevel() {
        Level minimumLevel = Level.OFF;
        for (int i = 0; i < this.loggingProviders.length; ++i) {
            Level level = this.loggingProviders[i].getMinimumLevel();
            if (level.ordinal() >= minimumLevel.ordinal()) continue;
            minimumLevel = level;
        }
        return minimumLevel;
    }

    @Override
    public Level getMinimumLevel(String tag) {
        Level minimumLevel = Level.OFF;
        for (int i = 0; i < this.loggingProviders.length; ++i) {
            Level level = this.loggingProviders[i].getMinimumLevel(tag);
            if (level.ordinal() >= minimumLevel.ordinal()) continue;
            minimumLevel = level;
        }
        return minimumLevel;
    }

    @Override
    public boolean isEnabled(int depth, String tag, Level level) {
        for (int i = 0; i < this.loggingProviders.length; ++i) {
            if (!this.loggingProviders[i].isEnabled(depth + 1, tag, level)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void log(int depth, String tag, Level level, Throwable exception, MessageFormatter formatter, Object obj, Object ... arguments) {
        for (int i = 0; i < this.loggingProviders.length; ++i) {
            this.loggingProviders[i].log(depth + 1, tag, level, exception, formatter, obj, arguments);
        }
    }

    @Override
    public void log(String loggerClassName, String tag, Level level, Throwable exception, MessageFormatter formatter, Object obj, Object ... arguments) {
        for (int i = 0; i < this.loggingProviders.length; ++i) {
            this.loggingProviders[i].log(loggerClassName, tag, level, exception, formatter, obj, arguments);
        }
    }

    @Override
    public void shutdown() throws InterruptedException {
        for (int i = 0; i < this.loggingProviders.length; ++i) {
            this.loggingProviders[i].shutdown();
        }
    }

    private static ContextProvider createContextProvider(Collection<LoggingProvider> loggingProviders) {
        ArrayList<ContextProvider> contextProviders = new ArrayList<ContextProvider>(loggingProviders.size());
        for (LoggingProvider loggingProvider : loggingProviders) {
            contextProviders.add(loggingProvider.getContextProvider());
        }
        return new BundleContextProvider(contextProviders);
    }

    List<LoggingProvider> getLoggingProviders() {
        return Arrays.asList(this.loggingProviders);
    }
}

