/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.datapack;

import org.spongepowered.api.advancement.AdvancementTemplate;
import org.spongepowered.api.adventure.ChatTypeTemplate;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.api.event.cause.entity.damage.DamageTypeTemplate;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.tag.TagTemplate;
import org.spongepowered.api.tag.Taggable;
import org.spongepowered.api.util.annotation.CatalogedBy;
import org.spongepowered.api.world.WorldTypeTemplate;
import org.spongepowered.api.world.biome.BiomeTemplate;
import org.spongepowered.api.world.generation.carver.CarverTemplate;
import org.spongepowered.api.world.generation.config.noise.DensityFunctionTemplate;
import org.spongepowered.api.world.generation.config.noise.NoiseGeneratorConfigTemplate;
import org.spongepowered.api.world.generation.config.noise.NoiseTemplate;
import org.spongepowered.api.world.generation.feature.FeatureTemplate;
import org.spongepowered.api.world.generation.feature.PlacedFeatureTemplate;
import org.spongepowered.api.world.generation.structure.SchematicTemplate;
import org.spongepowered.api.world.generation.structure.StructureSetTemplate;
import org.spongepowered.api.world.generation.structure.StructureTemplate;
import org.spongepowered.api.world.generation.structure.jigsaw.JigsawPoolTemplate;
import org.spongepowered.api.world.generation.structure.jigsaw.ProcessorListTemplate;
import org.spongepowered.api.world.server.WorldTemplate;

@CatalogedBy(value={DataPackTypes.class})
public interface DataPackType<T> {
    public DataPack<T> pack(String var1, String var2);

    public static interface Factory {
        public DataPackType<AdvancementTemplate> advancement();

        public DataPackType<RecipeRegistration> recipe();

        public DataPackType<WorldTypeTemplate> worldType();

        public DataPackType<WorldTemplate> world();

        public <T extends Taggable<T>> DataPackType<TagTemplate<T>> tag(RegistryType<T> var1);

        public DataPackType<BiomeTemplate> biome();

        public DataPackType<CarverTemplate> carver();

        public DataPackType<FeatureTemplate> feature();

        public DataPackType<PlacedFeatureTemplate> placedFeature();

        public DataPackType<NoiseGeneratorConfigTemplate> noiseGeneratorConfig();

        public DataPackType<NoiseTemplate> noise();

        public DataPackType<DensityFunctionTemplate> densityFunction();

        public DataPackType<StructureTemplate> structure();

        public DataPackType<SchematicTemplate> schematic();

        public DataPackType<ProcessorListTemplate> processorList();

        public DataPackType<StructureSetTemplate> structureSet();

        public DataPackType<JigsawPoolTemplate> jigsawPool();

        public DataPackType<ChatTypeTemplate> chatType();

        public DataPackType<DamageTypeTemplate> damageType();
    }
}

