/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.permission;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectReference;

public interface SubjectCollection {
    public String identifier();

    public Predicate<String> identifierValidityPredicate();

    public CompletableFuture<? extends Subject> loadSubject(String var1);

    public Optional<? extends Subject> subject(String var1);

    public CompletableFuture<Boolean> hasSubject(String var1);

    public CompletableFuture<? extends Map<String, ? extends Subject>> loadSubjects(Iterable<String> var1);

    public Collection<? extends Subject> loadedSubjects();

    public CompletableFuture<? extends Set<String>> allIdentifiers();

    public SubjectReference newSubjectReference(String var1);

    default public CompletableFuture<Void> applyToAll(Consumer<Subject> action) {
        Objects.requireNonNull(action, "action");
        return CompletableFuture.runAsync(() -> {
            Set<String> identifiers = this.allIdentifiers().join();
            this.applyToAll(identifiers, action).join();
        });
    }

    default public CompletableFuture<Void> applyToAll(Iterable<String> identifiers, Consumer<Subject> action) {
        Objects.requireNonNull(action, "action");
        Objects.requireNonNull(identifiers, "identifiers");
        return CompletableFuture.runAsync(() -> {
            for (String id : identifiers) {
                Subject subject = this.loadSubject(id).join();
                action.accept(subject);
                this.suggestUnload(subject.identifier());
            }
        });
    }

    public CompletableFuture<? extends Map<? extends SubjectReference, Boolean>> allWithPermission(String var1);

    public CompletableFuture<? extends Map<? extends SubjectReference, Boolean>> allWithPermission(String var1, Cause var2);

    public Map<? extends Subject, Boolean> loadedWithPermission(String var1);

    public Map<? extends Subject, Boolean> loadedWithPermission(String var1, Cause var2);

    public Subject defaults();

    public void suggestUnload(String var1);
}

