/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.biome;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.entity.EntityCategory;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.tag.Taggable;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.util.annotation.CatalogedBy;
import org.spongepowered.api.world.biome.Biomes;
import org.spongepowered.api.world.biome.ambient.ParticleConfig;
import org.spongepowered.api.world.biome.ambient.SoundConfig;
import org.spongepowered.api.world.biome.climate.GrassColorModifier;
import org.spongepowered.api.world.biome.climate.Precipitation;
import org.spongepowered.api.world.biome.climate.TemperatureModifier;
import org.spongepowered.api.world.biome.spawner.NaturalSpawnCost;
import org.spongepowered.api.world.biome.spawner.NaturalSpawner;
import org.spongepowered.api.world.generation.carver.Carver;
import org.spongepowered.api.world.generation.carver.CarvingStep;
import org.spongepowered.api.world.generation.feature.DecorationStep;
import org.spongepowered.api.world.generation.feature.PlacedFeature;

@CatalogedBy(value={Biomes.class})
public interface Biome
extends DataHolder,
Taggable<Biome> {
    default public double temperature() {
        return this.require(Keys.BIOME_TEMPERATURE);
    }

    default public double humidity() {
        return this.require(Keys.HUMIDITY);
    }

    default public Precipitation precipitation() {
        return this.require(Keys.PRECIPITATION);
    }

    default public boolean hasPrecipitation() {
        return this.require(Keys.HAS_PRECIPITATION);
    }

    default public TemperatureModifier temperatureModifier() {
        return this.require(Keys.TEMPERATURE_MODIFIER);
    }

    default public Map<CarvingStep, List<Carver>> carvers() {
        return (Map)this.require(Keys.CARVERS);
    }

    default public Map<DecorationStep, List<PlacedFeature>> features() {
        return (Map)this.require(Keys.FEATURES);
    }

    default public double generationSpawnChance() {
        return this.require(Keys.SPAWN_CHANCE);
    }

    default public Map<EntityCategory, List<NaturalSpawner>> spawners() {
        return (Map)this.require(Keys.NATURAL_SPAWNERS);
    }

    default public Map<EntityType<?>, NaturalSpawnCost> cost() {
        return (Map)this.require(Keys.NATURAL_SPAWNER_COST);
    }

    default public Color fogColor() {
        return this.require(Keys.FOG_COLOR);
    }

    default public Color waterColor() {
        return this.require(Keys.WATER_COLOR);
    }

    default public Color waterFogColor() {
        return this.require(Keys.WATER_FOG_COLOR);
    }

    default public Color skyColor() {
        return this.require(Keys.SKY_COLOR);
    }

    default public Optional<Color> foliageColor() {
        return this.get(Keys.FOLIAGE_COLOR);
    }

    default public Optional<Color> grassColor() {
        return this.get(Keys.GRASS_COLOR);
    }

    default public GrassColorModifier grassColorModifier() {
        return this.require(Keys.GRASS_COLOR_MODIFIER);
    }

    default public Optional<ParticleConfig> ambientParticle() {
        return this.get(Keys.AMBIENT_PARTICLE);
    }

    default public Optional<SoundType> ambientSound() {
        return this.get(Keys.AMBIENT_SOUND);
    }

    default public Optional<SoundConfig.Mood> ambientMood() {
        return this.get(Keys.AMBIENT_MOOD);
    }

    default public Optional<SoundConfig.Additional> additionalAmbientSound() {
        return this.get(Keys.AMBIENT_ADDITIONAL_SOUND);
    }

    default public Optional<SoundConfig.BackgroundMusic> backgroundMusic() {
        return this.get(Keys.BACKGROUND_MUSIC);
    }
}

