/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.biome;

import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.util.Range;
import org.spongepowered.api.world.biome.Biome;

public interface BiomeAttributes {
    public static BiomeAttributes point(float temperature, float humidity, float continentalness, float erosion, float depth, float weirdness, float offset) {
        return Sponge.game().factoryProvider().provide(Factory.class).ofPoint(temperature, humidity, continentalness, erosion, depth, weirdness, offset);
    }

    public static BiomeAttributes range(Range<Float> temperature, Range<Float> humidity, Range<Float> continentalness, Range<Float> erosion, Range<Float> depth, Range<Float> weirdness, float offset) {
        return Sponge.game().factoryProvider().provide(Factory.class).ofRange(temperature, humidity, continentalness, erosion, depth, weirdness, offset);
    }

    public static Optional<BiomeAttributes> defaultAttributes(RegistryReference<Biome> biome) {
        return Sponge.game().factoryProvider().provide(Factory.class).defaultAttributes(biome);
    }

    public Range<Float> temperature();

    public Range<Float> humidity();

    public Range<Float> continentalness();

    public Range<Float> erosion();

    public Range<Float> depth();

    public Range<Float> weirdness();

    public float offset();

    public static interface Factory {
        public Range<Float> fullRange();

        public BiomeAttributes ofPoint(float var1, float var2, float var3, float var4, float var5, float var6, float var7);

        public BiomeAttributes ofRange(Range<Float> var1, Range<Float> var2, Range<Float> var3, Range<Float> var4, Range<Float> var5, Range<Float> var6, float var7);

        public Optional<BiomeAttributes> defaultAttributes(RegistryReference<Biome> var1);
    }
}

