/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;

public abstract class SpongePlatform
implements Platform {
    private final MinecraftVersion minecraftVersion;
    protected final Map<String, Object> platformMap = new HashMap<String, Object>(){
        private static final long serialVersionUID = 7022397614988467398L;

        @Override
        public Object put(String key, Object value) {
            if (this.containsKey(key)) {
                throw new IllegalArgumentException(String.format("Cannot set the value of the existing key %s", key));
            }
            return super.put(key, value);
        }
    };

    protected SpongePlatform(MinecraftVersion minecraftVersion) {
        this.minecraftVersion = minecraftVersion;
    }

    @Override
    public final Platform.Type type() {
        return !((Launch)Launch.instance()).dedicatedServer() ? Platform.Type.CLIENT : Platform.Type.SERVER;
    }

    @Override
    public final PluginContainer container(Platform.Component component) {
        switch (component) {
            case API: {
                return ((Launch)Launch.instance()).apiPlugin();
            }
            case IMPLEMENTATION: {
                return ((Launch)Launch.instance()).platformPlugin();
            }
            case GAME: {
                return ((Launch)Launch.instance()).minecraftPlugin();
            }
        }
        throw new AssertionError((Object)("Unknown platform component: " + component));
    }

    @Override
    public final Platform.Type executionType() {
        if (Sponge.isServerAvailable() && Sponge.server().onMainThread()) {
            return Platform.Type.SERVER;
        }
        if (Sponge.isClientAvailable() && Sponge.client().onMainThread()) {
            return Platform.Type.CLIENT;
        }
        return Platform.Type.UNKNOWN;
    }

    @Override
    public final MinecraftVersion minecraftVersion() {
        return this.minecraftVersion;
    }

    protected void createPlatformMetadata() {
        PluginContainer apiPlugin = ((Launch)Launch.instance()).apiPlugin();
        PluginContainer commonPlugin = ((Launch)Launch.instance()).commonPlugin();
        PluginContainer platformPlugin = ((Launch)Launch.instance()).platformPlugin();
        this.platformMap.put("Type", (Object)this.type());
        this.platformMap.put("APIName", apiPlugin.metadata().name());
        this.platformMap.put("APIVersion", apiPlugin.metadata().version());
        this.platformMap.put("CommonName", commonPlugin.metadata().name());
        this.platformMap.put("CommonVersion", commonPlugin.metadata().version());
        this.platformMap.put("PlatformName", platformPlugin.metadata().name());
        this.platformMap.put("PlatformVersion", platformPlugin.metadata().version());
        this.platformMap.put("MinecraftVersion", this.minecraftVersion());
    }

    public final String toString() {
        return new StringJoiner(", ", SpongePlatform.class.getSimpleName() + "[", "]").add("type=" + this.type()).add("executionType=" + this.executionType()).add("api=" + ((Launch)Launch.instance()).apiPlugin().metadata().id()).add("platform=" + ((Launch)Launch.instance()).platformPlugin().metadata().id()).add("minecraftVersion=" + this.minecraftVersion()).toString();
    }
}

