/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement.criterion;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.OperatorCriterion;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTrigger;
import org.spongepowered.api.advancement.criteria.trigger.Trigger;
import org.spongepowered.api.util.Nameable;
import org.spongepowered.common.advancement.criterion.DefaultedAdvancementCriterion;

public class SpongeOperatorCriterion
implements OperatorCriterion,
DefaultedAdvancementCriterion {
    private final String name;
    private final Collection<AdvancementCriterion> criteria;
    private @Nullable Collection<AdvancementCriterion> recursiveChildrenCriteria;
    private @Nullable Collection<AdvancementCriterion> leafChildrenCriteria;

    SpongeOperatorCriterion(String namePrefix, Collection<AdvancementCriterion> criteria) {
        this.name = namePrefix + Arrays.toString(criteria.stream().map(Nameable::name).toArray(String[]::new));
        this.criteria = ImmutableSet.copyOf(criteria);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Optional<FilteredTrigger<?>> trigger() {
        return Optional.empty();
    }

    @Override
    public Optional<Trigger<?>> type() {
        return Optional.empty();
    }

    private Collection<AdvancementCriterion> getAllChildrenCriteria0(boolean onlyLeaves) {
        ImmutableSet.Builder criteria = ImmutableSet.builder();
        if (!onlyLeaves) {
            criteria.add((Object)this);
        }
        for (AdvancementCriterion criterion : this.criteria) {
            if (!(criterion instanceof OperatorCriterion)) continue;
            criteria.addAll(((SpongeOperatorCriterion)criterion).getAllChildrenCriteria0(onlyLeaves));
        }
        return criteria.build();
    }

    private Collection<AdvancementCriterion> getRecursiveChildren() {
        if (this.recursiveChildrenCriteria == null) {
            this.recursiveChildrenCriteria = this.getAllChildrenCriteria0(false);
        }
        return this.recursiveChildrenCriteria;
    }

    @Override
    public Collection<AdvancementCriterion> criteria() {
        return this.criteria;
    }

    @Override
    public Collection<AdvancementCriterion> leafCriteria() {
        if (this.leafChildrenCriteria == null) {
            this.leafChildrenCriteria = this.getAllChildrenCriteria0(true);
        }
        return this.leafChildrenCriteria;
    }

    @Override
    public Collection<AdvancementCriterion> find(String name) {
        return (Collection)this.getRecursiveChildren().stream().filter(c -> c.name().equals(name)).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Optional<AdvancementCriterion> findFirst(String name) {
        return this.getRecursiveChildren().stream().filter(c -> c.name().equals(name)).findFirst();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpongeOperatorCriterion)) {
            return false;
        }
        SpongeOperatorCriterion that = (SpongeOperatorCriterion)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.criteria, that.criteria);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.criteria != null ? this.criteria.hashCode() : 0);
        return result;
    }
}

