/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ChatTypeDecoration;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.RegistryOps;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.adventure.ChatTypeTemplate;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeChatTypeTemplate
extends Record
implements ChatTypeTemplate {
    private final ResourceKey key;
    private final ChatType representedType;
    private final DataPack<ChatTypeTemplate> pack;

    public SpongeChatTypeTemplate(ResourceKey key, ChatType representedType, DataPack<ChatTypeTemplate> pack) {
        this.key = key;
        this.representedType = representedType;
        this.pack = pack;
    }

    @Override
    public org.spongepowered.api.adventure.ChatType type() {
        return (org.spongepowered.api.adventure.ChatType)this.representedType;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongeChatTypeTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized ChatType:\n" + serialized, e);
        }
    }

    public static JsonElement encode(ChatTypeTemplate template, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return (JsonElement)ChatType.CODEC.encodeStart((DynamicOps)ops, (Object)((ChatType)template.type())).getOrThrow(false, e -> {});
    }

    public static ChatType decode(JsonElement json, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return (ChatType)ChatType.CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow(false, e -> {});
    }

    public static ChatTypeTemplate decode(DataPack<ChatTypeTemplate> pack, ResourceKey key, JsonElement packEntry, RegistryAccess registryAccess) {
        ChatType parsed = SpongeChatTypeTemplate.decode(packEntry, registryAccess);
        return new SpongeChatTypeTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeChatTypeTemplate.class, "key;representedType;pack", "key", "representedType", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeChatTypeTemplate.class, "key;representedType;pack", "key", "representedType", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeChatTypeTemplate.class, "key;representedType;pack", "key", "representedType", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public ChatType representedType() {
        return this.representedType;
    }

    @Override
    public DataPack<ChatTypeTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<org.spongepowered.api.adventure.ChatType, ChatTypeTemplate, ChatTypeTemplate.Builder>
    implements ChatTypeTemplate.Builder {
        private String translationKey;
        private Style style;
        private List<ChatTypeDecoration.Parameter> parameters;
        private ChatTypeDecoration narration;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public ChatTypeTemplate.Builder fromValue(org.spongepowered.api.adventure.ChatType value) {
            ChatType chatType = (ChatType)value;
            this.translationKey = chatType.chat().translationKey();
            this.parameters = chatType.chat().parameters();
            this.style = chatType.chat().style();
            this.narration = chatType.narration();
            return this;
        }

        @Override
        public ChatTypeTemplate.Builder translationKey(String translationKey) {
            this.translationKey = translationKey;
            return this;
        }

        @Override
        public ChatTypeTemplate.Builder style(net.kyori.adventure.text.format.Style style) {
            this.style = SpongeAdventure.asVanilla(style);
            return this;
        }

        private void addParameter(ChatTypeDecoration.Parameter parameter) {
            if (this.parameters.contains(parameter)) {
                // empty if block
            }
            this.parameters.add(parameter);
        }

        @Override
        public ChatTypeTemplate.Builder addSender() {
            if (this.parameters == null) {
                this.parameters = new ArrayList<ChatTypeDecoration.Parameter>();
            }
            this.addParameter(ChatTypeDecoration.Parameter.SENDER);
            return this;
        }

        @Override
        public ChatTypeTemplate.Builder addContent() {
            if (this.parameters == null) {
                this.parameters = new ArrayList<ChatTypeDecoration.Parameter>();
            }
            this.addParameter(ChatTypeDecoration.Parameter.CONTENT);
            return this;
        }

        @Override
        public ChatTypeTemplate.Builder addTarget() {
            if (this.parameters == null) {
                this.parameters = new ArrayList<ChatTypeDecoration.Parameter>();
            }
            this.addParameter(ChatTypeDecoration.Parameter.TARGET);
            return this;
        }

        @Override
        public Function<ChatTypeTemplate, org.spongepowered.api.adventure.ChatType> valueExtractor() {
            return ChatTypeTemplate::type;
        }

        @Override
        public ChatTypeTemplate.Builder reset() {
            this.key = null;
            this.pack = DataPacks.CHAT_TYPE;
            this.translationKey = null;
            this.style = Style.EMPTY;
            this.parameters = null;
            this.narration = ChatTypeDecoration.withSender((String)"chat.type.text.narrate");
            return this;
        }

        @Override
        public ChatTypeTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(pack));
            ChatType chatType = SpongeChatTypeTemplate.decode(json, (RegistryAccess)SpongeCommon.server().registryAccess());
            this.fromValue((org.spongepowered.api.adventure.ChatType)chatType);
            return this;
        }

        @Override
        protected ChatTypeTemplate build0() {
            Objects.requireNonNull(this.translationKey, "name");
            Objects.requireNonNull(this.parameters, "parameter");
            Objects.requireNonNull(this.style, "style");
            ChatType chatType = new ChatType(new ChatTypeDecoration(this.translationKey, this.parameters, this.style), this.narration);
            return new SpongeChatTypeTemplate(this.key, chatType, this.pack);
        }
    }
}

