/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.bridge.network.chat;

import java.util.Optional;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.message.PlayerChatEvent;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.event.tracking.PhaseTracker;

public class SpongeChatDecorator
implements ChatDecorator {
    public Component decorate(@Nullable ServerPlayer player, Component message) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.SERVER.pushCauseFrame();){
            if (player != null) {
                frame.pushCause(player);
            }
            net.kyori.adventure.text.Component component = SpongeAdventure.asAdventure(message);
            PlayerChatEvent.Decorate event = SpongeEventFactory.createPlayerChatEventDecorate(frame.currentCause(), component, component, Optional.ofNullable((org.spongepowered.api.entity.living.player.server.ServerPlayer)player));
            SpongeCommon.post(event);
            MutableComponent mutableComponent = SpongeAdventure.asVanillaMutable(event.message());
            return mutableComponent;
        }
    }
}

