/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.dispatcher;

import com.mojang.brigadier.AmbiguityConsumer;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.manager.CommandManager;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.command.ExecuteCommandEvent;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.commands.CommandSourceStackBridge;
import org.spongepowered.common.command.brigadier.SpongeImmutableArgumentReader;
import org.spongepowered.common.command.brigadier.SpongeStringReader;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContext;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilder;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeNodePermissionCache;
import org.spongepowered.common.command.brigadier.tree.DummyCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongeArgumentCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongeNode;
import org.spongepowered.common.command.brigadier.tree.SpongeRootCommandNode;
import org.spongepowered.common.command.exception.SpongeCommandSyntaxException;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.command.registrar.SpongeRawCommandRegistrar;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.general.CommandPhaseContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.util.CommandUtil;

public final class SpongeCommandDispatcher
extends CommandDispatcher<CommandSourceStack> {
    private ResultConsumer<CommandSourceStack> resultConsumer = (context, success, result) -> {};
    private final SpongeCommandManager commandManager;

    public SpongeCommandDispatcher(SpongeCommandManager commandManager) {
        super((RootCommandNode)new SpongeRootCommandNode());
        this.commandManager = commandManager;
    }

    public LiteralCommandNode<CommandSourceStack> register(LiteralCommandNode<CommandSourceStack> command) {
        this.getRoot().addChild(command);
        return command;
    }

    public void setConsumer(ResultConsumer<CommandSourceStack> consumer) {
        super.setConsumer(consumer);
        this.resultConsumer = consumer;
    }

    public ParseResults<CommandSourceStack> parse(String command, CommandSourceStack source) {
        return this.parse(command, source, false);
    }

    public ParseResults<CommandSourceStack> parse(String command, CommandSourceStack source, boolean isSuggestion) {
        SpongeCommandContextBuilder builder = new SpongeCommandContextBuilder(this, source, (CommandNode<CommandSourceStack>)this.getRoot(), 0);
        return this.parseNodes(true, isSuggestion, (CommandNode<CommandSourceStack>)this.getRoot(), new SpongeStringReader(command), builder);
    }

    public ParseResults<CommandSourceStack> parse(StringReader command, CommandSourceStack source) {
        return this.parse(command, source, false);
    }

    public ParseResults<CommandSourceStack> parse(StringReader command, CommandSourceStack source, boolean isSuggestion) {
        SpongeCommandContextBuilder builder = new SpongeCommandContextBuilder(this, source, (CommandNode<CommandSourceStack>)this.getRoot(), command.getCursor());
        SpongeStringReader reader = new SpongeStringReader(command);
        return this.parseNodes(true, isSuggestion, (CommandNode<CommandSourceStack>)this.getRoot(), reader, builder);
    }

    public int execute(ParseResults<CommandSourceStack> parse) throws CommandSyntaxException {
        String fullCommand = parse.getReader().getString();
        CommandSourceStack source = (CommandSourceStack)parse.getContext().getSource();
        ServerPlayer player = source.getPlayer();
        String originalRawCommand = PhaseTracker.getCauseStackManager().currentContext().get(EventContextKeys.COMMAND).orElse(fullCommand);
        String[] origSplitArg = originalRawCommand.split(" ", 2);
        String originalCommand = origSplitArg[0];
        String originalArgs = origSplitArg.length == 2 ? origSplitArg[1] : "";
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            CommandSourceStackBridge sourceBridge = (CommandSourceStackBridge)source;
            frame.addContext(EventContextKeys.COMMAND, fullCommand);
            sourceBridge.bridge$updateFrameFromCommandSource(frame);
            CommandCause cause = sourceBridge.bridge$withCurrentCause();
            parse.getContext().withSource((Object)((CommandSourceStack)cause));
            String[] splitArg = fullCommand.split(" ", 2);
            String baseCommand = splitArg[0];
            String args = splitArg.length == 2 ? splitArg[1] : "";
            CommandMapping mapping = this.commandManager.commandMapping(baseCommand).orElse(null);
            CommandPhaseContext context = ((CommandPhaseContext)GeneralPhase.State.COMMAND.createPhaseContext(PhaseTracker.getInstance()).source(source)).command(fullCommand).commandMapping(mapping);
            try {
                if (player != null) {
                    context.creator(player.getUUID());
                    context.notifier(player.getUUID());
                }
                context.buildAndSwitch();
                int result = this.execute0(parse, fullCommand);
                SpongeCommon.post(SpongeEventFactory.createExecuteCommandEventPost(cause.cause(), originalArgs, args, originalCommand, baseCommand, cause, CommandResult.builder().result(result).build()));
                int n = result;
                if (context != null) {
                    context.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    int n = this.commandManager.handleException(originalCommand, originalArgs, cause, throwable3, baseCommand, args);
                    if (frame != null) {
                        frame.close();
                    }
                    return n;
                }
            }
        }
    }

    private int execute0(ParseResults<CommandSourceStack> parse, String command) throws CommandSyntaxException {
        if (parse.getReader().canRead()) {
            if (parse.getExceptions().size() == 1) {
                throw (CommandSyntaxException)((Object)parse.getExceptions().values().iterator().next());
            }
            if (parse.getContext().getRange().isEmpty()) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parse.getReader());
            }
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(parse.getReader());
        }
        int result = 0;
        int successfulForks = 0;
        boolean forked = false;
        boolean foundCommand = false;
        CommandContext original = parse.getContext().build(command);
        List<CommandContext> contexts = Collections.singletonList(original);
        ArrayList<CommandContext> next = null;
        while (contexts != null) {
            int size = contexts.size();
            for (int i = 0; i < size; ++i) {
                CommandContext context = contexts.get(i);
                CommandContext child = context.getChild();
                if (child != null) {
                    forked |= context.isForked();
                    if (!child.hasNodes()) continue;
                    RedirectModifier modifier = context.getRedirectModifier();
                    if (modifier == null) {
                        if (next == null) {
                            next = new ArrayList<CommandContext>(1);
                        }
                        next.add(child.copyFor((Object)((CommandSourceStack)context.getSource())));
                        continue;
                    }
                    try {
                        Collection results = modifier.apply(context);
                        if (results.isEmpty()) continue;
                        if (next == null) {
                            next = new ArrayList(results.size());
                        }
                        for (CommandSourceStack source : results) {
                            next.add(child.copyFor((Object)source));
                        }
                        continue;
                    }
                    catch (CommandSyntaxException ex) {
                        foundCommand = true;
                        this.resultConsumer.onCommandComplete(context, false, 0);
                        if (forked) continue;
                        throw ex;
                    }
                }
                if (context.getCommand() == null) continue;
                foundCommand = true;
                try {
                    int value = context.getCommand().run(context);
                    result += value;
                    this.resultConsumer.onCommandComplete(context, true, value);
                    ++successfulForks;
                    continue;
                }
                catch (CommandSyntaxException ex) {
                    this.resultConsumer.onCommandComplete(context, false, 0);
                    if (forked) continue;
                    throw ex;
                }
            }
            contexts = next;
            next = null;
        }
        if (!foundCommand) {
            this.resultConsumer.onCommandComplete(original, false, 0);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parse.getReader());
        }
        return forked ? successfulForks : result;
    }

    private ParseResults<CommandSourceStack> parseNodes(boolean isRoot, boolean isSuggestion, CommandNode<CommandSourceStack> node, SpongeStringReader originalReader, SpongeCommandContextBuilder contextSoFar) {
        SpongeStringReader reader;
        if (isRoot) {
            String args;
            String command;
            String originalArgs;
            String rawCommand = originalReader.getString();
            String[] splitArg = rawCommand.split(" ", 2);
            String originalCommand = splitArg[0];
            String string = originalArgs = splitArg.length == 2 ? splitArg[1] : "";
            if (isSuggestion || rawCommand.isEmpty()) {
                command = originalCommand;
                args = originalArgs;
                reader = originalReader;
            } else {
                CommandCause cause = ((CommandSourceStackBridge)contextSoFar.getSource()).bridge$withCurrentCause();
                ExecuteCommandEvent.Pre preEvent = SpongeEventFactory.createExecuteCommandEventPre(cause.cause(), originalArgs, originalArgs, originalCommand, originalCommand, cause, Optional.empty(), false);
                if (SpongeCommon.post(preEvent) || preEvent.result().isPresent()) {
                    CommandResult result = preEvent.result().orElse(SpongeCommandManager.UNKNOWN_ERROR);
                    contextSoFar.withCommand((Command<CommandSourceStack>)((Command)ctx -> result.result()));
                    return new ParseResults((CommandContextBuilder)contextSoFar, (ImmutableStringReader)originalReader, Map.of());
                }
                command = preEvent.command();
                args = preEvent.arguments();
                reader = new SpongeStringReader(command + (String)(args.isEmpty() ? "" : " " + args));
            }
            Optional<CommandMapping> mapping = this.commandManager.commandMapping(command);
            if (mapping.isPresent() && mapping.get().registrar() instanceof SpongeRawCommandRegistrar) {
                contextSoFar.withCommand((Command<CommandSourceStack>)((Command)ctx -> {
                    CommandCause cause = (CommandCause)ctx.getSource();
                    try {
                        return this.commandManager.processCommand(cause, (CommandMapping)mapping.get(), command, args).result();
                    }
                    catch (CommandException e) {
                        return this.commandManager.handleException(originalCommand, originalArgs, cause, e, command, args);
                    }
                }));
                while (reader.canRead()) {
                    reader.skip();
                }
                return new ParseResults((CommandContextBuilder)contextSoFar, (ImmutableStringReader)reader.immutable(), Map.of());
            }
        } else {
            reader = originalReader;
        }
        return this.parseNodes0(isRoot, isSuggestion, node, reader, contextSoFar);
    }

    private ParseResults<CommandSourceStack> parseNodes0(boolean isRoot, boolean isSuggestion, CommandNode<CommandSourceStack> node, SpongeStringReader originalReader, SpongeCommandContextBuilder contextSoFar) {
        CommandSourceStack source = contextSoFar.getSource();
        LinkedHashMap<CommandNode<CommandSourceStack>, CommandSyntaxException> errors = null;
        ArrayList<ParseResults> potentials = null;
        int cursor = originalReader.getCursor();
        Collection nodes = isSuggestion && node instanceof SpongeNode ? ((SpongeNode)node).getRelevantNodesForSuggestions(originalReader) : (originalReader.canRead() ? node.getRelevantNodes((StringReader)originalReader) : (Collection)node.getChildren().stream().filter(n -> n instanceof SpongeArgumentCommandNode && ((SpongeArgumentCommandNode)n).getParser().doesNotRead()).collect(Collectors.toList()));
        for (CommandNode<CommandSourceStack> child : nodes) {
            boolean doesNotRead;
            boolean bl = doesNotRead = child instanceof SpongeArgumentCommandNode && ((SpongeArgumentCommandNode)child).getParser().doesNotRead();
            if (!SpongeNodePermissionCache.canUse(isRoot, this, child, source)) continue;
            SpongeCommandContextBuilder context = contextSoFar.copy();
            SpongeStringReader reader = new SpongeStringReader(originalReader);
            try {
                try {
                    child.parse((StringReader)reader, (CommandContextBuilder)context);
                }
                catch (RuntimeException ex) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)ex.getMessage());
                }
                if (reader.getCursor() == cursor) {
                    if (isSuggestion && !reader.canRead()) {
                        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherExpectedArgumentSeparator().createWithContext((ImmutableStringReader)reader);
                    }
                    reader.unskipWhitespace();
                } else if (reader.canRead() && reader.peek() != ' ') {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherExpectedArgumentSeparator().createWithContext((ImmutableStringReader)reader);
                }
            }
            catch (CommandSyntaxException ex) {
                if (errors == null) {
                    errors = new LinkedHashMap<CommandNode<CommandSourceStack>, CommandSyntaxException>();
                }
                errors.put(child, ex);
                reader.setCursor(cursor);
                continue;
            }
            context.withCommand((Command<CommandSourceStack>)child.getCommand());
            if (this.shouldContinueTraversing(reader, child)) {
                reader.skip();
                CommandNode redirect = child.getRedirect();
                if (redirect != null) {
                    boolean redirectingToRoot = redirect == this.getRoot();
                    SpongeCommandContextBuilder childContext = new SpongeCommandContextBuilder(this, source, (CommandNode<CommandSourceStack>)child.getRedirect(), reader.getCursor());
                    context.applySpongeElementsTo(childContext, false);
                    ParseResults parse = null;
                    if (redirectingToRoot) {
                        SpongeImmutableArgumentReader snapshot = reader.immutable();
                        try {
                            String commandToAttempt = reader.peekString();
                            int offset = reader.cursor();
                            if (redirect.getChild(commandToAttempt) == null) {
                                reader.parseString();
                                boolean hasMore = reader.canRead();
                                reader.skipWhitespace();
                                Optional<CommandMapping> optionalMapping = this.commandManager.commandMapping(commandToAttempt);
                                if (optionalMapping.isPresent()) {
                                    String[] stringArray;
                                    CommandMapping mapping = optionalMapping.get();
                                    String remaining = reader.remaining();
                                    childContext.withCommand((Command<CommandSourceStack>)((Command)commandContext -> {
                                        SpongeCommandContext spongeContext = (SpongeCommandContext)commandContext;
                                        try {
                                            return this.commandManager.processCommand(spongeContext.cause(), mapping, commandToAttempt, remaining).result();
                                        }
                                        catch (CommandException e) {
                                            throw new SpongeCommandSyntaxException(e, spongeContext);
                                        }
                                    }));
                                    childContext.withNode((CommandNode<CommandSourceStack>)new DummyCommandNode(childContext.getCommand()), StringRange.between((int)offset, (int)reader.totalLength()));
                                    if (hasMore) {
                                        String[] stringArray2 = new String[2];
                                        stringArray2[0] = commandToAttempt;
                                        stringArray = stringArray2;
                                        stringArray2[1] = remaining;
                                    } else {
                                        String[] stringArray3 = new String[1];
                                        stringArray = stringArray3;
                                        stringArray3[0] = commandToAttempt;
                                    }
                                    childContext.setNonBrigCommand(stringArray);
                                    reader.setCursor(reader.totalLength());
                                    parse = new ParseResults((CommandContextBuilder)childContext, (ImmutableStringReader)reader, Collections.emptyMap());
                                } else {
                                    reader.setState(snapshot);
                                }
                            }
                        }
                        catch (ArgumentParseException ignored) {
                            reader.setState(snapshot);
                        }
                    }
                    if (parse == null) {
                        parse = this.parseNodes0(redirect instanceof RootCommandNode, isSuggestion, (CommandNode<CommandSourceStack>)child.getRedirect(), reader, childContext);
                    }
                    childContext.applySpongeElementsTo(context, true);
                    context.withChild((CommandContextBuilder<CommandSourceStack>)parse.getContext());
                    ParseResults parse2 = new ParseResults((CommandContextBuilder)context, parse.getReader(), parse.getExceptions());
                    if (doesNotRead && potentials != null) {
                        potentials.add(parse2);
                        continue;
                    }
                    return parse2;
                }
                ParseResults<CommandSourceStack> parse = this.parseNodes0(false, isSuggestion, child, reader, context);
                if (potentials == null) {
                    potentials = new ArrayList(1);
                }
                potentials.add(parse);
                continue;
            }
            if (potentials == null) {
                potentials = new ArrayList<ParseResults>(1);
            }
            potentials.add(new ParseResults((CommandContextBuilder)context, (ImmutableStringReader)reader, Collections.emptyMap()));
        }
        if (potentials != null) {
            if (potentials.size() > 1) {
                potentials.sort((a, b) -> {
                    if (!a.getReader().canRead() && b.getReader().canRead()) {
                        return -1;
                    }
                    if (a.getReader().canRead() && !b.getReader().canRead()) {
                        return 1;
                    }
                    if (a.getExceptions().isEmpty() && !b.getExceptions().isEmpty()) {
                        return -1;
                    }
                    if (!a.getExceptions().isEmpty() && b.getExceptions().isEmpty()) {
                        return 1;
                    }
                    Command<CommandSourceStack> aCommand = SpongeCommandDispatcher.getCommand((CommandContextBuilder<CommandSourceStack>)a.getContext());
                    Command<CommandSourceStack> bCommand = SpongeCommandDispatcher.getCommand((CommandContextBuilder<CommandSourceStack>)b.getContext());
                    if (aCommand == null && bCommand != null) {
                        return 1;
                    }
                    if (aCommand != null && bCommand == null) {
                        return -1;
                    }
                    return 0;
                });
            }
            return (ParseResults)potentials.get(0);
        }
        return new ParseResults((CommandContextBuilder)contextSoFar, (ImmutableStringReader)originalReader, errors == null ? Collections.emptyMap() : errors);
    }

    private static Command<CommandSourceStack> getCommand(CommandContextBuilder<CommandSourceStack> context) {
        Command command = context.getCommand();
        if (command == null && context.getChild() != null) {
            return SpongeCommandDispatcher.getCommand((CommandContextBuilder<CommandSourceStack>)context.getChild());
        }
        return command;
    }

    public CompletableFuture<Suggestions> getCompletionSuggestions(ParseResults<CommandSourceStack> parse, int cursor) {
        CommandContextBuilder context = parse.getContext();
        CommandContextBuilder child = context.getLastChild();
        if (child instanceof SpongeCommandContextBuilder) {
            SpongeCommandContextBuilder spongeChild = (SpongeCommandContextBuilder)child;
            if (((SpongeCommandContextBuilder)child).representsNonBrigCommand()) {
                String rawCommand = parse.getReader().getString();
                String[] command = spongeChild.nonBrigCommand();
                CommandMapping mapping = this.commandManager.commandMapping(command[0]).get();
                return CommandUtil.createSuggestionsForRawCommand(rawCommand, spongeChild.nonBrigCommand(), spongeChild.cause(), mapping).buildFuture();
            }
        }
        SuggestionContext nodeBeforeCursor = context.findSuggestionContext(cursor);
        CommandNode parent = nodeBeforeCursor.parent;
        int start = Math.min(nodeBeforeCursor.startPos, cursor);
        String fullInput = parse.getReader().getString();
        String truncatedInput = fullInput.substring(0, cursor);
        Collection<CommandNode<CommandSourceStack>> children = parent instanceof SpongeNode ? ((SpongeNode)parent).getChildrenForSuggestions() : parent.getChildren();
        CompletableFuture[] futures = new CompletableFuture[children.size()];
        int i = 0;
        for (CommandNode<CommandSourceStack> node : children) {
            CompletableFuture future = Suggestions.empty();
            try {
                future = node.listSuggestions(context.build(truncatedInput), new SuggestionsBuilder(truncatedInput, start));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            futures[i++] = future;
        }
        return CompletableFuture.allOf(futures).handle((voidResult, exception) -> {
            ArrayList<Suggestions> suggestions = new ArrayList<Suggestions>();
            for (CompletableFuture future : futures) {
                if (future.isCompletedExceptionally()) continue;
                suggestions.add((Suggestions)future.join());
            }
            return Suggestions.merge((String)fullInput, suggestions);
        });
    }

    public void findAmbiguities(AmbiguityConsumer<CommandSourceStack> consumer) {
    }

    private boolean shouldContinueTraversing(SpongeStringReader reader, CommandNode<CommandSourceStack> child) {
        CommandNode redirect = child.getRedirect();
        if (redirect == null) {
            return reader.canRead(2) || child.getChildren().stream().anyMatch(x -> x instanceof SpongeArgumentCommandNode && ((SpongeArgumentCommandNode)x).getParser().doesNotRead());
        }
        return reader.canRead(1) || redirect.getChildren().stream().anyMatch(x -> x instanceof SpongeArgumentCommandNode && ((SpongeArgumentCommandNode)x).getParser().doesNotRead());
    }

    CommandManager getCommandManager() {
        return this.commandManager;
    }
}

