/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.manager;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.command.registrar.CommandRegistrar;
import org.spongepowered.plugin.PluginContainer;

public final class SpongeCommandMapping
implements CommandMapping {
    private final String alias;
    private final Set<String> allAliases;
    private final @Nullable PluginContainer container;
    private final CommandRegistrar<?> registrar;

    public SpongeCommandMapping(String alias, Set<String> allAliases, @Nullable PluginContainer container, CommandRegistrar<?> registrar) {
        this.alias = alias;
        this.allAliases = ImmutableSet.copyOf(allAliases);
        this.container = container;
        this.registrar = registrar;
    }

    @Override
    public @NonNull String primaryAlias() {
        return this.alias;
    }

    @Override
    public @NonNull Set<String> allAliases() {
        return this.allAliases;
    }

    @Override
    public @NonNull Optional<PluginContainer> plugin() {
        return Optional.ofNullable(this.container);
    }

    @Override
    public @NonNull CommandRegistrar<?> registrar() {
        return this.registrar;
    }

    public String toString() {
        return "SpongeCommandMapping{alias='" + this.alias + "', allAliases=" + this.allAliases + ", container=" + this.container + ", registrar=" + this.registrar + "}";
    }
}

