/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueParser;
import org.spongepowered.api.command.parameter.managed.clientcompletion.ClientCompletionType;
import org.spongepowered.api.command.parameter.managed.clientcompletion.ClientCompletionTypes;
import org.spongepowered.common.command.brigadier.SpongeStringReader;

public final class SpongeDefaultValueParser<T>
implements ValueParser<T> {
    private static final List<ClientCompletionType> CLIENT_COMPLETION_TYPE = ImmutableList.of((Object)ClientCompletionTypes.NONE.get());
    private final Function<CommandCause, T> defaultFunction;

    public SpongeDefaultValueParser(Function<CommandCause, T> defaultFunction) {
        this.defaultFunction = defaultFunction;
    }

    @Override
    public Optional<? extends T> parseValue(Parameter.Key<? super T> parameterKey, ArgumentReader.Mutable reader, CommandContext.Builder context) throws ArgumentParseException {
        T result;
        try {
            result = this.defaultFunction.apply(context.cause());
        }
        catch (Exception ex) {
            throw ((SpongeStringReader)reader).createException((Component)Component.text((String)("An exception was thrown obtaining a default value for " + parameterKey.key())), ex);
        }
        if (result == null) {
            throw reader.createException((Component)Component.text((String)("No default value was supplied for " + parameterKey.key())));
        }
        return Optional.of(result);
    }

    @Override
    public List<ClientCompletionType> clientCompletionType() {
        return CLIENT_COMPLETION_TYPE;
    }
}

