/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.entity;

import net.minecraft.world.entity.item.ItemEntity;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.bridge.world.entity.item.ItemEntityBridge;
import org.spongepowered.common.data.ByteToBooleanContentUpdater;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.SpongeTicks;

public final class ItemData {
    public static final Key<Value<Boolean>> INFINITE_DESPAWN_DELAY = ((Key.Builder)Key.builder().key(ResourceKey.sponge("infinite_despawn_delay"))).elementType(Boolean.class).build();
    public static final Key<Value<Boolean>> INFINITE_PICKUP_DELAY = ((Key.Builder)Key.builder().key(ResourceKey.sponge("infinite_pickup_delay"))).elementType(Boolean.class).build();
    private static final DataContentUpdater INFINITE_DELAYS_UPDATER_BYTE_TO_BOOL_FIX = new ByteToBooleanContentUpdater(1, 2, INFINITE_PICKUP_DELAY, INFINITE_DESPAWN_DELAY);

    private ItemData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemEntity.class).create(Keys.ITEM_STACK_SNAPSHOT).get(h -> ItemStackUtil.snapshotOf(h.getItem()))).set((h, v) -> h.setItem(ItemStackUtil.fromSnapshotToNative(v)))).asMutable(ItemEntityBridge.class).create(Keys.DESPAWN_DELAY).get(h -> SpongeTicks.ticksOrInfinite(h.bridge$getDespawnDelay(), Short.MIN_VALUE))).setAnd((h, v) -> {
            int ticks = SpongeTicks.toSaturatedIntOrInfinite(v, Short.MIN_VALUE);
            if (!v.isInfinite() && ticks < 0) {
                return false;
            }
            h.bridge$setDespawnDelay(ticks);
            return true;
        })).create(Keys.PICKUP_DELAY).get(h -> SpongeTicks.ticksOrInfinite(h.bridge$getPickupDelay(), Short.MAX_VALUE))).set((h, v) -> h.bridge$setPickupDelay(SpongeTicks.toSaturatedIntOrInfinite(v, Short.MAX_VALUE)))).create(INFINITE_DESPAWN_DELAY).get(h -> h.bridge$getDespawnDelay() == Short.MIN_VALUE)).set((h, v) -> h.bridge$setDespawnDelay(Short.MIN_VALUE))).create(INFINITE_PICKUP_DELAY).get(h -> h.bridge$getPickupDelay() == Short.MAX_VALUE)).set((h, v) -> h.bridge$setPickupDelay(Short.MAX_VALUE));
        ResourceKey item = ResourceKey.sponge("item");
        registrator.spongeDataStore(item, 2, new DataContentUpdater[]{INFINITE_DELAYS_UPDATER_BYTE_TO_BOOL_FIX}, ItemEntityBridge.class, INFINITE_PICKUP_DELAY, INFINITE_DESPAWN_DELAY);
        SpongeDataManager.INSTANCE.registerLegacySpongeData("InfinitePickupDelay", item, INFINITE_PICKUP_DELAY);
        SpongeDataManager.INSTANCE.registerLegacySpongeData("InfiniteDespawnDelay", item, INFINITE_DESPAWN_DELAY);
    }
}

