/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.meta.BannerPatternLayer;
import org.spongepowered.api.data.type.BannerPatternShape;
import org.spongepowered.api.data.type.BannerPatternShapes;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.NBTCollectors;

public final class ShieldItemStackData {
    private static final Map<String, BannerPatternShape> SHAPE_BY_HASHNAME = new HashMap<String, BannerPatternShape>();

    private ShieldItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        Registry bannerRegistry = BuiltInRegistries.BANNER_PATTERN;
        bannerRegistry.stream().forEach(pattern -> SHAPE_BY_HASHNAME.put(pattern.getHashname(), (BannerPatternShape)pattern));
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.DYE_COLOR).get(h -> {
            CompoundTag tag = h.getTagElement("BlockEntityTag");
            if (tag == null || tag.contains("Patterns", 9)) {
                return DyeColors.WHITE.get();
            }
            int id = tag.getInt("Base");
            return (DyeColor)net.minecraft.world.item.DyeColor.byId((int)id);
        })).set((h, v) -> {
            CompoundTag tag = h.getOrCreateTagElement("BlockEntityTag");
            tag.putInt("Base", ((net.minecraft.world.item.DyeColor)v).getId());
        })).supports(h -> h.getItem() instanceof ShieldItem)).create(Keys.BANNER_PATTERN_LAYERS).get(h -> {
            CompoundTag tag = h.getTagElement("BlockEntityTag");
            if (tag == null || !tag.contains("Patterns", 9)) {
                return new ArrayList();
            }
            ListTag layersList = tag.getList("Patterns", 10);
            return layersList.stream().map(layer -> ShieldItemStackData.layerFromNbt((CompoundTag)layer)).collect(Collectors.toList());
        })).set((h, v) -> {
            ListTag layersTag = v.stream().filter(layer -> layer.shape() != BannerPatternShapes.BASE.get()).map(ShieldItemStackData::layerToNbt).collect(NBTCollectors.toTagList());
            CompoundTag blockEntity = h.getOrCreateTagElement("BlockEntityTag");
            blockEntity.put("Patterns", (Tag)layersTag);
            if (h.getItem() instanceof ShieldItem) {
                v.stream().filter(layer -> layer.shape() == BannerPatternShapes.BASE.get()).forEach(layer -> blockEntity.putInt("Base", ((net.minecraft.world.item.DyeColor)layer.color()).getId()));
            }
        })).supports(h -> h.getItem() instanceof ShieldItem || h.getItem() instanceof BannerItem);
    }

    public static BannerPatternLayer layerFromNbt(CompoundTag nbt) {
        BannerPatternShape shape = SHAPE_BY_HASHNAME.get(nbt.getString("Pattern"));
        net.minecraft.world.item.DyeColor dyeColor = net.minecraft.world.item.DyeColor.byId((int)nbt.getInt("Color"));
        return BannerPatternLayer.of(shape, (DyeColor)dyeColor);
    }

    public static CompoundTag layerToNbt(BannerPatternLayer layer) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("Pattern", ((BannerPattern)layer.shape()).getHashname());
        nbt.putInt("Color", ((net.minecraft.world.item.DyeColor)layer.color()).getId());
        return nbt;
    }
}

